/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka;

import io.micronaut.configuration.kafka.config.AbstractKafkaProducerConfiguration;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.exceptions.ConfigurationException;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.Serializer;

@Factory
public class KafkaProducerFactory {
    @Prototype
    public <K, V> KafkaProducer<K, V> createProducer(@Parameter AbstractKafkaProducerConfiguration<K, V> producerConfiguration) {
        Optional<Serializer<K>> keySerializer = producerConfiguration.getKeySerializer();
        Optional<Serializer<V>> valueSerializer = producerConfiguration.getValueSerializer();
        Properties config = producerConfiguration.getConfig();
        if (keySerializer.isPresent() && valueSerializer.isPresent()) {
            Serializer<K> ks = keySerializer.get();
            Serializer<V> vs = valueSerializer.get();
            return new KafkaProducer(config, ks, vs);
        }
        if (keySerializer.isPresent() || valueSerializer.isPresent()) {
            throw new ConfigurationException("Both the [keySerializer] and [valueSerializer] must be set when setting either");
        }
        return new KafkaProducer(config);
    }
}

