/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.bind.batch;

import io.micronaut.configuration.kafka.bind.ConsumerRecordBinderRegistry;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.ArgumentBinderRegistry;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Singleton;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.reactivestreams.Publisher;

@Singleton
public class BatchConsumerRecordsBinderRegistry
implements ArgumentBinderRegistry<ConsumerRecords<?, ?>> {
    private final ConsumerRecordBinderRegistry consumerRecordBinderRegistry;

    public BatchConsumerRecordsBinderRegistry(ConsumerRecordBinderRegistry consumerRecordBinderRegistry) {
        this.consumerRecordBinderRegistry = consumerRecordBinderRegistry;
    }

    public <T> Optional<ArgumentBinder<T, ConsumerRecords<?, ?>>> findArgumentBinder(Argument<T> argument, ConsumerRecords<?, ?> source) {
        Class argType = argument.getType();
        if (Iterable.class.isAssignableFrom(argType) || argType.isArray() || Publishers.isConvertibleToPublisher((Class)argType)) {
            Argument batchType = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            ArrayList bound = new ArrayList();
            return Optional.of((context, consumerRecords) -> {
                for (ConsumerRecord consumerRecord : consumerRecords) {
                    Optional<ArgumentBinder<ArgumentBinder, ConsumerRecord<?, ?>>> binder = this.consumerRecordBinderRegistry.findArgumentBinder(argument, consumerRecord);
                    binder.ifPresent(b -> {
                        Argument newArg = Argument.of((Class)batchType.getType(), (String)argument.getName(), (AnnotationMetadata)argument.getAnnotationMetadata(), (Argument[])batchType.getTypeParameters());
                        ArgumentConversionContext conversionContext = ConversionContext.of((Argument)newArg);
                        ArgumentBinder.BindingResult result = b.bind(conversionContext, (Object)consumerRecord);
                        if (result.isPresentAndSatisfied()) {
                            bound.add(result.get());
                        }
                    });
                }
                return () -> {
                    if (Publisher.class.isAssignableFrom(argument.getType())) {
                        return ConversionService.SHARED.convert((Object)Flowable.fromIterable((Iterable)bound), argument);
                    }
                    return ConversionService.SHARED.convert((Object)bound, argument);
                };
            });
        }
        return Optional.empty();
    }
}

