/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.scope;

import io.micronaut.configuration.kafka.ProducerRegistry;
import io.micronaut.configuration.kafka.annotation.KafkaClient;
import io.micronaut.configuration.kafka.config.AbstractKafkaProducerConfiguration;
import io.micronaut.configuration.kafka.config.DefaultKafkaProducerConfiguration;
import io.micronaut.configuration.kafka.serde.SerdeRegistry;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.exceptions.DependencyInjectionException;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.ParametrizedProvider;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KafkaClientScope
implements CustomScope<KafkaClient>,
LifeCycle<KafkaClientScope>,
ProducerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaClientScope.class);
    private final Map<ClientKey, Producer> clients = new ConcurrentHashMap<ClientKey, Producer>();
    private final BeanContext beanContext;
    private final SerdeRegistry serdeRegistry;

    public KafkaClientScope(BeanContext beanContext, SerdeRegistry serdeRegistry) {
        this.beanContext = beanContext;
        this.serdeRegistry = serdeRegistry;
    }

    public boolean isRunning() {
        return true;
    }

    public Class<KafkaClient> annotationType() {
        return KafkaClient.class;
    }

    public <T> T get(BeanResolutionContext resolutionContext, BeanDefinition<T> beanDefinition, BeanIdentifier identifier, Provider<T> provider) {
        BeanResolutionContext.Segment segment = (BeanResolutionContext.Segment)resolutionContext.getPath().currentSegment().orElseThrow(() -> new IllegalStateException("@KafkaClient used in invalid location"));
        Argument argument = segment.getArgument();
        AnnotationValue annotation = (AnnotationValue)argument.findAnnotation(KafkaClient.class).orElseThrow(() -> new DependencyInjectionException(resolutionContext, argument, "KafkaClientScope called for injection point that is not annotated with @KafkaClient"));
        if (!Producer.class.isAssignableFrom(argument.getType())) {
            throw new DependencyInjectionException(resolutionContext, argument, "@KafkaClient used on type that is not a " + Producer.class.getName());
        }
        if (!(provider instanceof ParametrizedProvider)) {
            throw new DependencyInjectionException(resolutionContext, argument, "KafkaClientScope called with invalid bean provider");
        }
        Optional k = argument.getTypeVariable("K");
        Optional v = argument.getTypeVariable("V");
        if (!k.isPresent() || !v.isPresent()) {
            throw new DependencyInjectionException(resolutionContext, argument, "@KafkaClient used on type missing generic argument values for Key and Value");
        }
        String id = annotation.getValue(String.class).orElse(null);
        Argument keyArgument = (Argument)k.get();
        Argument valueArgument = (Argument)v.get();
        return this.getKafkaProducer(id, keyArgument, valueArgument);
    }

    @Override
    @Nonnull
    public <K, V> Producer<K, V> getProducer(String id, Argument<K> keyType, Argument<V> valueType) {
        return (Producer)this.getKafkaProducer(id, keyType, valueType);
    }

    private <T> T getKafkaProducer(@Nullable String id, Argument<?> keyType, Argument<?> valueType) {
        ClientKey key = new ClientKey(id, keyType.getType(), valueType.getType());
        return (T)this.clients.computeIfAbsent(key, clientKey -> {
            Supplier<AbstractKafkaProducerConfiguration> defaultResolver = () -> (AbstractKafkaProducerConfiguration)this.beanContext.getBean(AbstractKafkaProducerConfiguration.class);
            boolean hasId = StringUtils.isNotEmpty((CharSequence)id);
            AbstractKafkaProducerConfiguration config = hasId ? this.beanContext.findBean(AbstractKafkaProducerConfiguration.class, Qualifiers.byName((String)id)).orElseGet(defaultResolver) : defaultResolver.get();
            DefaultKafkaProducerConfiguration newConfig = new DefaultKafkaProducerConfiguration(config);
            Properties properties = newConfig.getConfig();
            if (!properties.containsKey("key.serializer")) {
                Serializer keySerializer = this.serdeRegistry.pickSerializer(keyType);
                newConfig.setKeySerializer(keySerializer);
            }
            if (!properties.containsKey("value.serializer")) {
                Serializer valueSerializer = this.serdeRegistry.pickSerializer(valueType);
                newConfig.setValueSerializer(valueSerializer);
            }
            if (hasId) {
                properties.putIfAbsent("client.id", id);
            }
            return (Producer)this.beanContext.createBean(Producer.class, new Object[]{newConfig});
        });
    }

    public KafkaClientScope stop() {
        for (Producer producer : this.clients.values()) {
            try {
                producer.close();
            }
            catch (Exception e) {
                LOG.warn("Error shutting down Kafka producer: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.clients.clear();
        return this;
    }

    public <T> Optional<T> remove(BeanIdentifier identifier) {
        return Optional.empty();
    }

    private class ClientKey {
        private final String id;
        private final Class keyType;
        private final Class valueType;

        ClientKey(String id, Class keyType, Class valueType) {
            this.id = id;
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientKey clientKey = (ClientKey)o;
            return Objects.equals(this.id, clientKey.id) && Objects.equals(this.keyType, clientKey.keyType) && Objects.equals(this.valueType, clientKey.valueType);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.keyType, this.valueType);
        }
    }
}

