/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.serde;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.serialize.exceptions.SerializationException;
import io.micronaut.jackson.serialize.JacksonObjectSerializer;
import java.util.Map;
import javax.inject.Inject;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;

@Prototype
public class JsonSerde<T>
implements Serializer<T>,
Deserializer<T>,
Serde<T> {
    private final JacksonObjectSerializer objectSerializer;
    private final Class<T> type;

    @Inject
    public JsonSerde(JacksonObjectSerializer objectSerializer, @Parameter Class<T> type) {
        this.objectSerializer = objectSerializer;
        this.type = type;
    }

    public JsonSerde(Class<T> type) {
        this.objectSerializer = new JacksonObjectSerializer(new ObjectMapper());
        this.type = type;
    }

    public JsonSerde(ObjectMapper objectMapper, Class<T> type) {
        this.objectSerializer = new JacksonObjectSerializer(objectMapper);
        this.type = type;
    }

    public T deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        return this.objectSerializer.deserialize(data, this.type).orElseThrow(() -> new SerializationException("Unable to deserialize data: " + data));
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] serialize(String topic, T data) {
        if (data == null) {
            return null;
        }
        return (byte[])this.objectSerializer.serialize(data).orElseThrow(() -> new SerializationException("Unable to serialize data: " + data));
    }

    public void close() {
    }

    public Serializer<T> serializer() {
        return this;
    }

    public Deserializer<T> deserializer() {
        return this;
    }

    public String toString() {
        return "JsonSerde: " + this.type.getName();
    }
}

