/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.tracing;

import io.micronaut.configuration.kafka.tracing.brave.BraveKafkaConsumerTracingInstrumentation;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.opentracing.Tracer;
import io.opentracing.contrib.kafka.TracingKafkaConsumer;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.kafka.clients.consumer.Consumer;

@Singleton
@Requirements(value={@Requires(beans={Tracer.class}), @Requires(missingBeans={BraveKafkaConsumerTracingInstrumentation.class}), @Requires(classes={TracingKafkaConsumer.class})})
public class KafkaConsumerTracingInstrumentation
implements BeanCreatedEventListener<Consumer<?, ?>> {
    private final Provider<Tracer> tracerProvider;

    protected KafkaConsumerTracingInstrumentation(Provider<Tracer> tracerProvider) {
        this.tracerProvider = tracerProvider;
    }

    public Consumer<?, ?> onCreated(BeanCreatedEvent<Consumer<?, ?>> event) {
        Consumer consumer = (Consumer)event.getBean();
        return new TracingKafkaConsumer(consumer, (Tracer)this.tracerProvider.get());
    }
}

