/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNull;
import io.micronaut.configuration.kafka.metrics.builder.KafkaMetricMeterTypeBuilder;
import io.micronaut.core.annotation.Internal;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsReporter;

@Internal
abstract class AbstractKafkaMetricsReporter
implements MetricsReporter,
MeterBinder,
Closeable {
    static final Collection<MeterRegistry> METER_REGISTRIES = new ConcurrentLinkedQueue<MeterRegistry>();
    private List<KafkaMetric> metrics;

    AbstractKafkaMetricsReporter() {
    }

    public void bindTo(@NonNull MeterRegistry registry) {
        if (!METER_REGISTRIES.contains(registry)) {
            METER_REGISTRIES.add(registry);
        }
    }

    public void init(List<KafkaMetric> metrics) {
        this.metrics = metrics;
        for (MeterRegistry meterRegistry : METER_REGISTRIES) {
            for (KafkaMetric metric : metrics) {
                this.registerMetric(meterRegistry, metric);
            }
        }
    }

    public void metricChange(KafkaMetric metric) {
        for (MeterRegistry meterRegistry : METER_REGISTRIES) {
            this.registerMetric(meterRegistry, metric);
        }
    }

    public void metricRemoval(KafkaMetric metric) {
    }

    public void configure(Map<String, ?> configs) {
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.metrics != null) {
            this.metrics.clear();
            this.metrics = null;
        }
        METER_REGISTRIES.clear();
    }

    private void registerMetric(MeterRegistry meterRegistry, KafkaMetric metric) {
        KafkaMetricMeterTypeBuilder.newBuilder().prefix(this.getMetricPrefix()).metric(metric).tagFunction(this.getTagFunction()).registry(meterRegistry).build();
    }

    private Function<MetricName, List<Tag>> getTagFunction() {
        return metricName -> metricName.tags().entrySet().stream().filter(entry -> this.getIncludedTags().contains(entry.getKey())).map(entry -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList());
    }

    protected Set<String> getIncludedTags() {
        return Collections.singleton("client-id");
    }

    protected abstract String getMetricPrefix();
}

