/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.serde;

import io.micronaut.configuration.kafka.serde.JsonSerde;
import io.micronaut.configuration.kafka.serde.SerdeRegistry;
import io.micronaut.context.BeanContext;
import io.micronaut.core.reflect.ClassUtils;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;

@Singleton
public class JsonSerdeRegistry
implements SerdeRegistry {
    private final BeanContext beanContext;
    private final Map<Class, JsonSerde> serdes = new ConcurrentHashMap<Class, JsonSerde>();

    protected JsonSerdeRegistry(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    @Override
    public <T> Serde<T> getSerde(Class<T> type) {
        if (ClassUtils.isJavaBasicType(type)) {
            return Serdes.serdeFrom(String.class);
        }
        JsonSerde jsonSerde = this.serdes.get(type);
        if (jsonSerde != null) {
            return jsonSerde;
        }
        jsonSerde = (JsonSerde)this.beanContext.createBean(JsonSerde.class, new Object[]{type});
        this.serdes.put(type, jsonSerde);
        return jsonSerde;
    }
}

