/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka;

import io.micronaut.configuration.kafka.ProducerRegistry;
import io.micronaut.configuration.kafka.TransactionalProducerRegistry;
import io.micronaut.configuration.kafka.annotation.KafkaClient;
import io.micronaut.configuration.kafka.config.AbstractKafkaProducerConfiguration;
import io.micronaut.configuration.kafka.config.DefaultKafkaProducerConfiguration;
import io.micronaut.configuration.kafka.serde.SerdeRegistry;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Any;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ArgumentInjectionPoint;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class KafkaProducerFactory
implements ProducerRegistry,
TransactionalProducerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaProducerFactory.class);
    private final Map<ClientKey, Producer> clients = new ConcurrentHashMap<ClientKey, Producer>();
    private final BeanContext beanContext;
    private final SerdeRegistry serdeRegistry;

    public KafkaProducerFactory(BeanContext beanContext, SerdeRegistry serdeRegistry) {
        this.beanContext = beanContext;
        this.serdeRegistry = serdeRegistry;
    }

    @Bean
    @Any
    public <K, V> Producer<K, V> getProducer(@Nullable InjectionPoint<KafkaProducer<K, V>> injectionPoint, @Nullable @Parameter AbstractKafkaProducerConfiguration<K, V> producerConfiguration) {
        Argument argument;
        if (injectionPoint == null) {
            if (producerConfiguration != null) {
                Optional<Serializer<K>> keySerializer = producerConfiguration.getKeySerializer();
                Optional<Serializer<V>> valueSerializer = producerConfiguration.getValueSerializer();
                Properties config = producerConfiguration.getConfig();
                if (keySerializer.isPresent() && valueSerializer.isPresent()) {
                    Serializer<K> ks = keySerializer.get();
                    Serializer<V> vs = valueSerializer.get();
                    return new KafkaProducer(config, ks, vs);
                }
                if (keySerializer.isPresent() || valueSerializer.isPresent()) {
                    throw new ConfigurationException("Both the [keySerializer] and [valueSerializer] must be set when setting either");
                }
                return new KafkaProducer(config);
            }
            throw new ConfigurationException("No Kafka configuration specified when using direct instantiation");
        }
        if (injectionPoint instanceof FieldInjectionPoint) {
            argument = ((FieldInjectionPoint)injectionPoint).asArgument();
        } else if (injectionPoint instanceof ArgumentInjectionPoint) {
            argument = ((ArgumentInjectionPoint)injectionPoint).getArgument();
        } else {
            throw new ConfigurationException("Cannot directly retrieve KafkaProducer instances. Use @Inject or constructor injection");
        }
        Argument k = argument.getTypeVariable("K").orElse(null);
        Argument v = argument.getTypeVariable("V").orElse(null);
        if (k == null || v == null) {
            throw new ConfigurationException("@KafkaClient used on type missing generic argument values for Key and Value: " + injectionPoint);
        }
        String id = injectionPoint.getAnnotationMetadata().stringValue(KafkaClient.class).orElse(null);
        return (Producer)this.getKafkaProducer(id, null, k, v, false);
    }

    private <T> T getKafkaProducer(@Nullable String id, @Nullable String transactionalId, Argument<?> keyType, Argument<?> valueType, boolean transactional) {
        ClientKey key = new ClientKey(id, keyType.getType(), valueType.getType(), transactional);
        return (T)this.clients.computeIfAbsent(key, clientKey -> {
            Supplier<AbstractKafkaProducerConfiguration> defaultResolver = () -> (AbstractKafkaProducerConfiguration)this.beanContext.getBean(AbstractKafkaProducerConfiguration.class);
            boolean hasId = StringUtils.isNotEmpty((CharSequence)id);
            AbstractKafkaProducerConfiguration config = hasId ? this.beanContext.findBean(AbstractKafkaProducerConfiguration.class, Qualifiers.byName((String)id)).orElseGet(defaultResolver) : defaultResolver.get();
            DefaultKafkaProducerConfiguration newConfig = new DefaultKafkaProducerConfiguration(config);
            Properties properties = newConfig.getConfig();
            if (!properties.containsKey("key.serializer")) {
                Serializer keySerializer = this.serdeRegistry.pickSerializer(keyType);
                newConfig.setKeySerializer(keySerializer);
            }
            if (!properties.containsKey("value.serializer")) {
                Serializer valueSerializer = this.serdeRegistry.pickSerializer(valueType);
                newConfig.setValueSerializer(valueSerializer);
            }
            if (StringUtils.isNotEmpty((CharSequence)transactionalId)) {
                properties.putIfAbsent("transactional.id", transactionalId);
                properties.putIfAbsent("enable.auto.commit", (Object)false);
            }
            if (hasId) {
                properties.putIfAbsent("client.id", id);
            }
            Producer producer = (Producer)this.beanContext.createBean(Producer.class, new Object[]{newConfig});
            if (transactional) {
                producer.initTransactions();
            }
            return producer;
        });
    }

    @PreDestroy
    protected void stop() {
        for (Producer producer : this.clients.values()) {
            try {
                producer.close();
            }
            catch (Exception e) {
                LOG.warn("Error shutting down Kafka producer: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.clients.clear();
    }

    @Override
    public <K, V> Producer<K, V> getProducer(String id, Argument<K> keyType, Argument<V> valueType) {
        return (Producer)this.getKafkaProducer(id, null, keyType, valueType, false);
    }

    @Override
    public <K, V> Producer<K, V> getTransactionalProducer(String id, String transactionalId, Argument<K> keyType, Argument<V> valueType) {
        return (Producer)this.getKafkaProducer(id, transactionalId, keyType, valueType, true);
    }

    @Override
    public void close(Producer<?, ?> producer) {
        for (Map.Entry<ClientKey, Producer> e : this.clients.entrySet()) {
            if (e.getValue() != producer) continue;
            this.clients.remove(e.getKey());
            break;
        }
    }

    private static final class ClientKey {
        private final String id;
        private final Class<?> keyType;
        private final Class<?> valueType;
        private final boolean transactional;

        ClientKey(String id, Class<?> keyType, Class<?> valueType, boolean transactional) {
            this.id = id;
            this.keyType = keyType;
            this.valueType = valueType;
            this.transactional = transactional;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientKey clientKey = (ClientKey)o;
            return Objects.equals(this.id, clientKey.id) && Objects.equals(this.keyType, clientKey.keyType) && Objects.equals(this.valueType, clientKey.valueType) && Objects.equals(this.transactional, clientKey.transactional);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.keyType, this.valueType, this.transactional);
        }
    }
}

