/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.exceptions;

import io.micronaut.messaging.exceptions.MessageListenerException;
import java.util.Optional;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class KafkaListenerException
extends MessageListenerException {
    private final Object listener;
    private final Consumer<?, ?> kafkaConsumer;
    private final ConsumerRecord<?, ?> consumerRecord;

    public KafkaListenerException(String message, Object listener, Consumer<?, ?> kafkaConsumer, ConsumerRecord<?, ?> consumerRecord) {
        super(message);
        this.listener = listener;
        this.kafkaConsumer = kafkaConsumer;
        this.consumerRecord = consumerRecord;
    }

    public KafkaListenerException(String message, Throwable cause, Object listener, Consumer<?, ?> kafkaConsumer, ConsumerRecord<?, ?> consumerRecord) {
        super(message, cause);
        this.listener = listener;
        this.kafkaConsumer = kafkaConsumer;
        this.consumerRecord = consumerRecord;
    }

    public KafkaListenerException(Throwable cause, Object listener, Consumer<?, ?> kafkaConsumer, ConsumerRecord<?, ?> consumerRecord) {
        super(cause.getMessage(), cause);
        this.listener = listener;
        this.kafkaConsumer = kafkaConsumer;
        this.consumerRecord = consumerRecord;
    }

    public Object getKafkaListener() {
        return this.listener;
    }

    public Consumer<?, ?> getKafkaConsumer() {
        return this.kafkaConsumer;
    }

    public Optional<ConsumerRecord<?, ?>> getConsumerRecord() {
        return Optional.ofNullable(this.consumerRecord);
    }
}

