/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.annotation;

import io.micronaut.configuration.kafka.annotation.ErrorStrategy;
import io.micronaut.configuration.kafka.annotation.OffsetReset;
import io.micronaut.configuration.kafka.annotation.OffsetStrategy;
import io.micronaut.context.annotation.AliasFor;
import io.micronaut.context.annotation.Property;
import io.micronaut.messaging.annotation.MessageListener;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.kafka.common.IsolationLevel;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.ANNOTATION_TYPE})
@MessageListener
public @interface KafkaListener {
    @AliasFor(member="groupId")
    public String value() default "";

    @AliasFor(member="value")
    public String groupId() default "";

    public boolean uniqueGroupId() default false;

    public String clientId() default "";

    public OffsetStrategy offsetStrategy() default OffsetStrategy.AUTO;

    public OffsetReset offsetReset() default OffsetReset.LATEST;

    public String producerClientId() default "";

    public String producerTransactionalId() default "";

    public IsolationLevel isolation() default IsolationLevel.READ_UNCOMMITTED;

    public ErrorStrategy errorStrategy() default @ErrorStrategy;

    public int threads() default 1;

    public String pollTimeout() default "100ms";

    public String sessionTimeout() default "";

    public String heartbeatInterval() default "";

    public boolean redelivery() default false;

    public boolean batch() default false;

    public Property[] properties() default {};

    public boolean autoStartup() default true;
}

