/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.config;

import io.micronaut.configuration.kafka.config.AbstractKafkaProducerConfiguration;
import io.micronaut.configuration.kafka.config.KafkaDefaultConfiguration;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.conventions.StringConvention;
import java.util.Map;
import java.util.Properties;

@EachProperty(value="kafka.producers", primary="default")
@Requires(beans={KafkaDefaultConfiguration.class})
public class KafkaProducerConfiguration<K, V>
extends AbstractKafkaProducerConfiguration<K, V> {
    public static final String PREFIX = "kafka.producers";

    public KafkaProducerConfiguration(@Parameter String producerName, KafkaDefaultConfiguration defaultConfiguration, Environment environment) {
        super(new Properties());
        Properties config = this.getConfig();
        config.putAll((Map<?, ?>)defaultConfiguration.getConfig());
        String propertyKey = "kafka.producers." + NameUtils.hyphenate((String)producerName, (boolean)true);
        if (environment.containsProperties(propertyKey)) {
            config.putAll((Map<?, ?>)environment.getProperties(propertyKey, StringConvention.RAW));
        }
    }
}

