/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.graal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.kafka.common.utils.ByteBufferUnmapper;
import org.apache.kafka.common.utils.Java;

@TargetClass(value=ByteBufferUnmapper.class)
public final class ByteBufferUnmapperSubstitute {
    @Substitute
    public static void unmap(String resourceDescription, ByteBuffer buffer) throws IOException {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Unmapping only works with direct buffers");
        }
        try {
            if (Java.IS_JAVA9_COMPATIBLE) {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Method m = unsafeClass.getMethod("cleaner", Void.TYPE, ByteBuffer.class);
                Field f = unsafeClass.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                Object theUnsafe = f.get(null);
                m.invoke(theUnsafe, buffer);
            } else {
                Class<?> directBufferClass = Class.forName("java.nio.DirectByteBuffer");
                Method cleanerMethod = directBufferClass.getMethod("cleaner", new Class[0]);
                cleanerMethod.setAccessible(true);
                Object cleaner = cleanerMethod.invoke((Object)buffer, new Object[0]);
                if (cleaner != null) {
                    Class<?> cleanerClass = Class.forName("sun.misc.Cleaner");
                    Method cleanMethod = cleanerClass.getMethod("clean", new Class[0]);
                    cleanMethod.setAccessible(true);
                    cleanMethod.invoke(cleaner, new Object[0]);
                }
            }
        }
        catch (Throwable throwable) {
            throw new IOException("Unable to unmap the mapped buffer: " + resourceDescription, throwable);
        }
    }
}

