/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.config;

import io.micronaut.configuration.kafka.config.AbstractKafkaConfiguration;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;

@ConfigurationProperties(value="kafka")
@Requirements(value={@Requires(property="kafka"), @Requires(property="kafka.enabled", notEquals="false")})
public class KafkaDefaultConfiguration
extends AbstractKafkaConfiguration {
    public static final int DEFAULT_HEALTHTIMEOUT = 10;
    private Duration healthTimeout = Duration.ofSeconds(10L);

    public KafkaDefaultConfiguration(Environment environment) {
        super(KafkaDefaultConfiguration.resolveDefaultConfiguration(environment));
        this.getConfig().putIfAbsent("bootstrap.servers", "localhost:9092");
    }

    public Duration getHealthTimeout() {
        return this.healthTimeout;
    }

    public void setHealthTimeout(Duration healthTimeout) {
        if (healthTimeout != null) {
            this.healthTimeout = healthTimeout;
        }
    }

    private static Properties resolveDefaultConfiguration(Environment environment) {
        Map values = environment.containsProperties("kafka") ? environment.getProperties("kafka") : Collections.emptyMap();
        Properties properties = new Properties();
        values.entrySet().stream().filter(entry -> {
            String key = (String)entry.getKey();
            return Stream.of("embedded", "consumers", "producers", "streams").noneMatch(key::startsWith);
        }).forEach(entry -> {
            Optional converted;
            Object value = entry.getValue();
            if (environment.canConvert(entry.getValue().getClass(), String.class) && (converted = environment.convert(entry.getValue(), String.class)).isPresent()) {
                value = converted.get();
            }
            properties.setProperty((String)entry.getKey(), value.toString());
        });
        return properties;
    }
}

