/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.metrics.builder;

import io.micronaut.configuration.kafka.metrics.builder.KafkaMetricMeterType;
import io.micronaut.configuration.kafka.metrics.builder.MeterType;
import io.micronaut.core.annotation.Internal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Internal
class KafkaMetricMeterTypeRegistry {
    private static final KafkaMetricMeterType DEFAULT_KAFKA_METRIC_METER_TYPE = new KafkaMetricMeterType();
    private static final String RECORDS = "records";
    private static final String PARTITIONS = "partitions";
    private static final String CONNECTIONS = "connections";
    private static final String JOINS = "joins";
    private static final String SYNCS = "syncs";
    private static final String HEARTBEATS = "heartbeats";
    private static final String REQUESTS = "requests";
    private static final String RESPONSES = "responses";
    private final Map<String, KafkaMetricMeterType> meterTypeMap = new HashMap<String, KafkaMetricMeterType>();

    public KafkaMetricMeterTypeRegistry() {
        this.meterTypeMap.put("records-lag", new KafkaMetricMeterType(MeterType.GAUGE, "The latest lag of the partition", RECORDS));
        this.meterTypeMap.put("records-lag-avg", new KafkaMetricMeterType(MeterType.GAUGE, "The average lag of the partition", RECORDS));
        this.meterTypeMap.put("records-lag-max", new KafkaMetricMeterType(MeterType.GAUGE, "The maximum lag in terms of number of records for any partition in this window. An increasing value over time is your best indication that the consumer group is not keeping up with the producers.", RECORDS));
        this.meterTypeMap.put("records-lead", new KafkaMetricMeterType(MeterType.GAUGE, "The latest lead of the partition.", RECORDS));
        this.meterTypeMap.put("records-lead-min", new KafkaMetricMeterType(MeterType.GAUGE, "The min lead of the partition. The lag between the consumer offset and the start offset of the log. If this gets close to zero, it's an indication that the consumer may lose data soon.", RECORDS));
        this.meterTypeMap.put("records-lead-avg", new KafkaMetricMeterType(MeterType.GAUGE, "The average lead of the partition.", RECORDS));
        this.meterTypeMap.put("fetch-size-avg", new KafkaMetricMeterType(MeterType.GAUGE, "The average number of bytes fetched per request.", "bytes"));
        this.meterTypeMap.put("fetch-size-max", new KafkaMetricMeterType(MeterType.GAUGE, "The maximum number of bytes fetched per request.", "bytes"));
        this.meterTypeMap.put("records-per-request-avg", new KafkaMetricMeterType(MeterType.GAUGE, "The average number of records in each request.", RECORDS));
        this.meterTypeMap.put("bytes-consumed-total", new KafkaMetricMeterType(MeterType.FUNCTION_COUNTER, "The total number of bytes consumed.", "bytes"));
        this.meterTypeMap.put("records-consumed-total", new KafkaMetricMeterType(MeterType.FUNCTION_COUNTER, "The total number of records consumed.", RECORDS));
        this.meterTypeMap.put("fetch-total", new KafkaMetricMeterType(MeterType.FUNCTION_COUNTER, "The number of fetch requests.", REQUESTS));
        this.meterTypeMap.put("fetch-latency-avg", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The average time taken for a fetch request."));
        this.meterTypeMap.put("fetch-latency-max", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The max time taken for a fetch request."));
        this.meterTypeMap.put("fetch-throttle-time-avg", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The average throttle time. When quotas are enabled, the broker may delay fetch requests in order to throttle a consumer which has exceeded its limit. This metric indicates how throttling time has been added to fetch requests on average."));
        this.meterTypeMap.put("fetch-throttle-time-max", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The maximum throttle time."));
        this.meterTypeMap.put("assigned-partitions", new KafkaMetricMeterType(MeterType.GAUGE, "The number of partitions currently assigned to this consumer.", PARTITIONS));
        this.meterTypeMap.put("commit-rate", new KafkaMetricMeterType(MeterType.GAUGE, "The number of commit calls per second.", "commits"));
        this.meterTypeMap.put("join-rate", new KafkaMetricMeterType(MeterType.GAUGE, "The number of group joins per second. Group joining is the first phase of the rebalance protocol. A large value indicates that the consumer group is unstable and will likely be coupled with increased lag.", JOINS));
        this.meterTypeMap.put("sync-rate", new KafkaMetricMeterType(MeterType.GAUGE, "The number of group syncs per second. Group synchronization is the second and last phase of the rebalance protocol. A large value indicates group instability.", SYNCS));
        this.meterTypeMap.put("heartbeat-rate", new KafkaMetricMeterType(MeterType.GAUGE, "The average number of heartbeats per second. After a rebalance, the consumer sends heartbeats to the coordinator to keep itself active in the group. You may see a lower rate than configured if the processing loop is taking more time to handle message batches. Usually this is OK as long as you see no increase in the join rate.", HEARTBEATS));
        this.meterTypeMap.put("commit-latency-avg", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The average time taken for a commit request."));
        this.meterTypeMap.put("commit-latency-max", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The max time taken for a commit request."));
        this.meterTypeMap.put("join-time-avg", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The average time taken for a group rejoin. This value can get as high as the configured session timeout for the consumer, but should usually be lower."));
        this.meterTypeMap.put("join-time-max", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The max time taken for a group rejoin. This value should not get much higher than the configured session timeout for the consumer."));
        this.meterTypeMap.put("sync-time-avg", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The average time taken for a group sync."));
        this.meterTypeMap.put("sync-time-max", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The max time taken for a group sync."));
        this.meterTypeMap.put("heartbeat-response-time-max", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The max time taken to receive a response to a heartbeat request."));
        this.meterTypeMap.put("last-heartbeat-seconds-ago", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The time since the last controller heartbeat.", TimeUnit.SECONDS));
        this.meterTypeMap.put("connection-count", new KafkaMetricMeterType(MeterType.GAUGE, "The current number of active connections.", CONNECTIONS));
        this.meterTypeMap.put("connection-creation-total", new KafkaMetricMeterType(MeterType.GAUGE, "New connections established.", CONNECTIONS));
        this.meterTypeMap.put("connection-close-total", new KafkaMetricMeterType(MeterType.GAUGE, "Connections closed.", CONNECTIONS));
        this.meterTypeMap.put("io-ratio", new KafkaMetricMeterType(MeterType.GAUGE, "The fraction of time the I/O thread spent doing I/O."));
        this.meterTypeMap.put("io-wait-ratio", new KafkaMetricMeterType(MeterType.GAUGE, "The fraction of time the I/O thread spent waiting."));
        this.meterTypeMap.put("select-total", new KafkaMetricMeterType(MeterType.GAUGE, "Number of times the I/O layer checked for new I/O to perform."));
        this.meterTypeMap.put("io-time-ns-avg", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The average length of time for I/O per select call.", TimeUnit.NANOSECONDS));
        this.meterTypeMap.put("io-wait-time-ns-avg", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The average length of time the I/O thread spent waiting for a socket to be ready for reads or writes.", TimeUnit.NANOSECONDS));
        this.meterTypeMap.put("successful-authentication-total", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The number of successful authentication attempts.", "authentication-attempts"));
        this.meterTypeMap.put("failed-authentication-total", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "The number of failed authentication attempts.", "authentication-attempts"));
        this.meterTypeMap.put("network-io-total", new KafkaMetricMeterType(MeterType.GAUGE, "", "bytes"));
        this.meterTypeMap.put("outgoing-byte-total", new KafkaMetricMeterType(MeterType.GAUGE, "", "bytes"));
        this.meterTypeMap.put("request-total", new KafkaMetricMeterType(MeterType.GAUGE, "", REQUESTS));
        this.meterTypeMap.put("response-total", new KafkaMetricMeterType(MeterType.GAUGE, "", RESPONSES));
        this.meterTypeMap.put("io-waittime-total", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "Time spent on the I/O thread waiting for a socket to be ready for reads or writes.", TimeUnit.NANOSECONDS));
        this.meterTypeMap.put("io-time-total", new KafkaMetricMeterType(MeterType.TIME_GAUGE, "Time spent in I/O during select calls.", TimeUnit.NANOSECONDS));
    }

    protected KafkaMetricMeterType lookup(String name) {
        return this.meterTypeMap.getOrDefault(name, DEFAULT_KAFKA_METRIC_METER_TYPE);
    }
}

