/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.health;

import io.micronaut.configuration.kafka.config.KafkaDefaultConfiguration;
import io.micronaut.configuration.kafka.health.NetworkClientCreator;
import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import jdk.jfr.Experimental;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;

@Experimental
@Singleton
public class DefaultNetworkClientCreator
implements NetworkClientCreator {
    private static final String LOG_PREFIX = "[HealthIndicator clientId=%s] ";
    private static final String DEFAULT_CLIENT_ID = "health-indicator-client";
    private static final String METRICS_NAMESPACE = "kafka.health-indicator.client";
    private final LogContext logContext;
    private final AbstractConfig config;
    private final String clientId;

    public DefaultNetworkClientCreator(KafkaDefaultConfiguration defaultConfiguration) {
        AdminClientConfig config = new AdminClientConfig((Map)defaultConfiguration.getConfig());
        String clientId = Optional.ofNullable(config.getString("client.id")).filter(Predicate.not(String::isEmpty)).orElse(DEFAULT_CLIENT_ID);
        this.config = config;
        this.logContext = new LogContext(String.format(LOG_PREFIX, clientId));
        this.clientId = clientId;
    }

    @Override
    @NonNull
    public NetworkClient create(ClusterResourceListener ... listeners) {
        long reconnectBackoff = this.config.getLong("reconnect.backoff.ms");
        long reconnectBackoffMax = this.config.getLong("reconnect.backoff.max.ms");
        int socketSendBuffer = this.config.getInt("send.buffer.bytes");
        int socketReceiveBuffer = this.config.getInt("receive.buffer.bytes");
        long connectionSetupTimeout = this.config.getLong("socket.connection.setup.timeout.ms");
        long connectionSetupTimeoutMax = this.config.getLong("socket.connection.setup.timeout.max.ms");
        Metrics metrics = null;
        Selector selector = null;
        ChannelBuilder channelBuilder = null;
        try {
            metrics = this.metrics();
            channelBuilder = ClientUtils.createChannelBuilder((AbstractConfig)this.config, (Time)Time.SYSTEM, (LogContext)this.logContext);
            selector = this.selector(metrics, channelBuilder);
            return new NetworkClient((Selectable)selector, this.metadata(listeners), this.clientId, 1, reconnectBackoff, reconnectBackoffMax, socketSendBuffer, socketReceiveBuffer, (int)TimeUnit.HOURS.toMillis(1L), connectionSetupTimeout, connectionSetupTimeoutMax, Time.SYSTEM, true, new ApiVersions(), this.logContext);
        }
        catch (Throwable e) {
            Utils.closeQuietly((AutoCloseable)metrics, (String)"Metrics");
            Utils.closeQuietly(selector, (String)"Selector");
            Utils.closeQuietly((AutoCloseable)channelBuilder, (String)"ChannelBuilder");
            throw new KafkaException("Failed to create new NetworkClient", e);
        }
    }

    private ClusterResourceListeners clusterListeners(ClusterResourceListener ... listeners) {
        ClusterResourceListeners clusterListeners = new ClusterResourceListeners();
        for (ClusterResourceListener listener : listeners) {
            clusterListeners.maybeAdd((Object)listener);
        }
        return clusterListeners;
    }

    private Metadata metadata(ClusterResourceListener ... listeners) {
        long refreshBackoff = this.config.getLong("retry.backoff.ms");
        long metadataExpire = this.config.getLong("metadata.max.age.ms");
        List urls = this.config.getList("bootstrap.servers");
        String clientDnsLookup = this.config.getString("client.dns.lookup");
        Metadata metadata = new Metadata(refreshBackoff, metadataExpire, this.logContext, this.clusterListeners(listeners));
        metadata.bootstrap(ClientUtils.parseAndValidateAddresses((List)urls, (String)clientDnsLookup));
        return metadata;
    }

    private Metrics metrics() {
        int samples = this.config.getInt("metrics.num.samples");
        long timeWindow = this.config.getLong("metrics.sample.window.ms");
        String recordLevel = this.config.getString("metrics.recording.level");
        MetricConfig metricConfig = new MetricConfig().samples(samples).timeWindow(timeWindow, TimeUnit.MILLISECONDS).recordLevel(Sensor.RecordingLevel.forName((String)recordLevel)).tags(Collections.singletonMap("client-id", this.clientId));
        KafkaMetricsContext context = new KafkaMetricsContext(METRICS_NAMESPACE, this.config.originalsWithPrefix("metrics.context."));
        return new Metrics(metricConfig, CommonClientConfigs.metricsReporters((String)this.clientId, (AbstractConfig)this.config), Time.SYSTEM, (MetricsContext)context);
    }

    private Selector selector(Metrics metrics, ChannelBuilder channelBuilder) {
        long connectionMaxIdle = this.config.getLong("connections.max.idle.ms");
        return new Selector(connectionMaxIdle, metrics, Time.SYSTEM, DEFAULT_CLIENT_ID, channelBuilder, this.logContext);
    }
}

