/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.serde;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.serialize.exceptions.SerializationException;
import io.micronaut.json.JsonObjectSerializer;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;

@Internal
@Prototype
public class JsonObjectSerde<T>
implements Serializer<T>,
Deserializer<T>,
Serde<T> {
    private final JsonObjectSerializer objectSerializer;
    private final Class<T> type;

    @Creator
    public JsonObjectSerde(JsonObjectSerializer objectSerializer, @Parameter Class<T> type) {
        this.objectSerializer = objectSerializer;
        this.type = type;
    }

    public T deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        return this.objectSerializer.deserialize(data, this.type).orElseThrow(() -> new SerializationException("Unable to deserialize data: " + data));
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] serialize(String topic, T data) {
        if (data == null) {
            return null;
        }
        return (byte[])this.objectSerializer.serialize(data).orElseThrow(() -> new SerializationException("Unable to serialize data: " + data));
    }

    public void close() {
    }

    public Serializer<T> serializer() {
        return this;
    }

    public Deserializer<T> deserializer() {
        return this;
    }

    public String toString() {
        return "JsonObjectSerde: " + this.type.getName();
    }
}

