/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka;

import io.micronaut.configuration.kafka.config.AbstractKafkaConsumerConfiguration;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.exceptions.ConfigurationException;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;

@Factory
public class KafkaConsumerFactory {
    @Prototype
    public <K, V> Consumer<K, V> createConsumer(@Parameter AbstractKafkaConsumerConfiguration<K, V> consumerConfiguration) {
        Optional<Deserializer<K>> keyDeserializer = consumerConfiguration.getKeyDeserializer();
        Optional<Deserializer<V>> valueDeserializer = consumerConfiguration.getValueDeserializer();
        Properties config = consumerConfiguration.getConfig();
        if (keyDeserializer.isPresent() && valueDeserializer.isPresent()) {
            return new KafkaConsumer(config, keyDeserializer.get(), valueDeserializer.get());
        }
        if (keyDeserializer.isPresent() || valueDeserializer.isPresent()) {
            throw new ConfigurationException("Both the [keyDeserializer] and [valueDeserializer] must be set when setting either");
        }
        return new KafkaConsumer(config);
    }
}

