/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.annotation;

import io.micronaut.core.annotation.Nullable;
import java.time.Duration;

public enum ErrorStrategyValue {
    RETRY_ON_ERROR,
    RETRY_EXPONENTIALLY_ON_ERROR,
    RESUME_AT_NEXT_RECORD,
    NONE;


    public boolean isRetry() {
        return this == RETRY_ON_ERROR || this == RETRY_EXPONENTIALLY_ON_ERROR;
    }

    public Duration computeRetryDelay(@Nullable Duration fixedRetryDelay, long retryAttempts) {
        Duration delay;
        if (!this.isRetry()) {
            return Duration.ZERO;
        }
        Duration duration = delay = fixedRetryDelay != null ? fixedRetryDelay : Duration.ofSeconds(1L);
        if (this == RETRY_EXPONENTIALLY_ON_ERROR) {
            return delay.multipliedBy(1L << (int)(retryAttempts - 1L));
        }
        return delay;
    }
}

