/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.bind;

import io.micronaut.configuration.kafka.annotation.KafkaKey;
import io.micronaut.configuration.kafka.bind.AnnotatedConsumerRecordBinder;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;

@Singleton
public class KafkaKeyBinder<T>
implements AnnotatedConsumerRecordBinder<KafkaKey, T> {
    private final ConversionService conversionService;

    public KafkaKeyBinder(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Class<KafkaKey> annotationType() {
        return KafkaKey.class;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, ConsumerRecord<?, ?> source) {
        Object key = source.key();
        Optional converted = this.conversionService.convert(key, context);
        return () -> converted;
    }
}

