/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.bind;

import io.micronaut.configuration.kafka.bind.AnnotatedConsumerRecordBinder;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.messaging.annotation.MessageBody;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;

@Singleton
public class KafkaMessagingBodyBinder<T>
implements AnnotatedConsumerRecordBinder<MessageBody, T> {
    private final ConversionService conversionService;

    public KafkaMessagingBodyBinder(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Class<MessageBody> annotationType() {
        return MessageBody.class;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, ConsumerRecord<?, ?> source) {
        Object value = source.value();
        Optional converted = this.conversionService.convert(value, context);
        return () -> converted;
    }
}

