/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.config;

import io.micronaut.configuration.kafka.config.AbstractKafkaConfiguration;
import io.micronaut.core.annotation.Nullable;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;

public abstract class AbstractKafkaConsumerConfiguration<K, V>
extends AbstractKafkaConfiguration<K, V> {
    private Deserializer<K> keyDeserializer;
    private Deserializer<V> valueDeserializer;

    protected AbstractKafkaConsumerConfiguration(Properties config) {
        super(config);
    }

    public Optional<Deserializer<K>> getKeyDeserializer() {
        return Optional.ofNullable(this.keyDeserializer);
    }

    public void setKeyDeserializer(@Nullable Deserializer<K> keyDeserializer) {
        if (keyDeserializer != null) {
            keyDeserializer.configure(Utils.propsToMap((Properties)this.getConfig()), true);
        }
        this.keyDeserializer = keyDeserializer;
    }

    public Optional<Deserializer<V>> getValueDeserializer() {
        return Optional.ofNullable(this.valueDeserializer);
    }

    public void setValueDeserializer(@Nullable Deserializer<V> valueDeserializer) {
        if (valueDeserializer != null) {
            valueDeserializer.configure(Utils.propsToMap((Properties)this.getConfig()), false);
        }
        this.valueDeserializer = valueDeserializer;
    }
}

