/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.seek;

import io.micronaut.configuration.kafka.seek.KafkaSeekOperation;
import io.micronaut.configuration.kafka.seek.KafkaSeeker;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
record DefaultKafkaSeeker(@NonNull Consumer<?, ?> consumer) implements KafkaSeeker
{
    private static final Logger LOG = LoggerFactory.getLogger(DefaultKafkaSeeker.class);

    public DefaultKafkaSeeker(@NonNull Consumer<?, ?> consumer) {
        Objects.requireNonNull(consumer, "consumer");
    }

    @Override
    public boolean perform(@NonNull KafkaSeekOperation operation) {
        try {
            Optional<Boolean> performed;
            TopicPartition tp = operation.topicPartition();
            if (operation.offset() == 0L && (performed = this.performForZeroOffset(operation, tp)).isPresent()) {
                return performed.get();
            }
            long offset = this.offset(operation, tp);
            this.consumer.seek(tp, Math.max(0L, offset));
            LOG.debug("Seek operation succeeded: {} - offset: {}", (Object)operation, (Object)offset);
            return true;
        }
        catch (Exception e) {
            LOG.error("Seek operation failed: {}", (Object)operation, (Object)e);
            return false;
        }
    }

    @NonNull
    private Optional<Boolean> performForZeroOffset(@NonNull KafkaSeekOperation operation, @NonNull TopicPartition tp) {
        String topic = operation.topic();
        int partition = operation.partition();
        switch (operation.offsetType()) {
            case FORWARD: 
            case BACKWARD: {
                LOG.debug("Relative zero-offset seek operation dropped: {}", (Object)operation);
                return Optional.of(false);
            }
            case BEGINNING: {
                this.consumer.seekToBeginning(Collections.singletonList(tp));
                LOG.debug("Seek to the beginning operation succeeded: {}-{}", (Object)topic, (Object)partition);
                return Optional.of(true);
            }
            case END: {
                this.consumer.seekToEnd(Collections.singletonList(tp));
                LOG.debug("Seek to the end operation succeeded: {}-{}", (Object)topic, (Object)partition);
                return Optional.of(true);
            }
        }
        return Optional.empty();
    }

    private long offset(@NonNull KafkaSeekOperation operation, @Nullable TopicPartition tp) {
        return switch (operation.offsetType()) {
            default -> throw new IncompatibleClassChangeError();
            case KafkaSeekOperation.OffsetType.ABSOLUTE -> operation.offset();
            case KafkaSeekOperation.OffsetType.FORWARD -> this.current(tp) + operation.offset();
            case KafkaSeekOperation.OffsetType.BACKWARD -> this.current(tp) - operation.offset();
            case KafkaSeekOperation.OffsetType.BEGINNING -> this.beginning(tp) + operation.offset();
            case KafkaSeekOperation.OffsetType.END -> this.end(tp) - operation.offset();
            case KafkaSeekOperation.OffsetType.TIMESTAMP -> this.earliest(tp, operation.offset()).orElseGet(() -> this.end(tp));
        };
    }

    private long current(TopicPartition tp) {
        return this.consumer.position(tp);
    }

    public long beginning(TopicPartition tp) {
        return (Long)this.consumer.beginningOffsets(Collections.singletonList(tp)).get(tp);
    }

    private long end(TopicPartition tp) {
        return (Long)this.consumer.endOffsets(Collections.singletonList(tp)).get(tp);
    }

    private Optional<Long> earliest(TopicPartition tp, long ts) {
        return Optional.ofNullable((OffsetAndTimestamp)this.consumer.offsetsForTimes(Collections.singletonMap(tp, ts)).get(tp)).map(OffsetAndTimestamp::offset);
    }
}

