/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.seek;

import io.micronaut.configuration.kafka.seek.DefaultKafkaSeekOperation;
import io.micronaut.core.annotation.NonNull;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.TopicPartition;

public interface KafkaSeekOperation {
    @NonNull
    public static KafkaSeekOperation seek(@NonNull TopicPartition topicPartition, long offset) {
        return new DefaultKafkaSeekOperation(topicPartition, OffsetType.ABSOLUTE, offset);
    }

    @NonNull
    public static KafkaSeekOperation seekRelativeToBeginning(@NonNull TopicPartition topicPartition, long offset) {
        return new DefaultKafkaSeekOperation(topicPartition, OffsetType.BEGINNING, offset);
    }

    @NonNull
    public static KafkaSeekOperation seekToBeginning(@NonNull TopicPartition topicPartition) {
        return new DefaultKafkaSeekOperation(topicPartition, OffsetType.BEGINNING, 0L);
    }

    @NonNull
    public static List<KafkaSeekOperation> seekToBeginning(@NonNull Collection<TopicPartition> partitions) {
        return partitions.stream().map(KafkaSeekOperation::seekToBeginning).toList();
    }

    @NonNull
    public static KafkaSeekOperation seekRelativeToEnd(@NonNull TopicPartition topicPartition, long offset) {
        return new DefaultKafkaSeekOperation(topicPartition, OffsetType.END, offset);
    }

    @NonNull
    public static KafkaSeekOperation seekToEnd(@NonNull TopicPartition topicPartition) {
        return new DefaultKafkaSeekOperation(topicPartition, OffsetType.END, 0L);
    }

    @NonNull
    public static List<KafkaSeekOperation> seekToEnd(@NonNull Collection<TopicPartition> partitions) {
        return partitions.stream().map(KafkaSeekOperation::seekToEnd).toList();
    }

    @NonNull
    public static KafkaSeekOperation seekForward(@NonNull TopicPartition topicPartition, long offset) {
        return new DefaultKafkaSeekOperation(topicPartition, OffsetType.FORWARD, offset);
    }

    @NonNull
    public static KafkaSeekOperation seekBackward(@NonNull TopicPartition topicPartition, long offset) {
        return new DefaultKafkaSeekOperation(topicPartition, OffsetType.BACKWARD, offset);
    }

    @NonNull
    public static KafkaSeekOperation seekToTimestamp(@NonNull TopicPartition topicPartition, long timestamp) {
        return new DefaultKafkaSeekOperation(topicPartition, OffsetType.TIMESTAMP, timestamp);
    }

    @NonNull
    public static List<KafkaSeekOperation> seekToTimestamp(@NonNull Collection<TopicPartition> topicPartitions, long timestamp) {
        return topicPartitions.stream().map(tp -> KafkaSeekOperation.seekToTimestamp(tp, timestamp)).toList();
    }

    @NonNull
    public TopicPartition topicPartition();

    @NonNull
    public OffsetType offsetType();

    public long offset();

    @NonNull
    default public String topic() {
        return this.topicPartition().topic();
    }

    default public int partition() {
        return this.topicPartition().partition();
    }

    public static enum OffsetType {
        ABSOLUTE,
        FORWARD,
        BACKWARD,
        BEGINNING,
        END,
        TIMESTAMP;

    }
}

