/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.admin;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import java.util.List;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Context
@Requirements(value={@Requires(bean=AdminClient.class), @Requires(bean=NewTopic.class)})
public class KafkaNewTopics {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaNewTopics.class);
    @NonNull
    private final CreateTopicsResult result;

    public KafkaNewTopics(@NonNull AdminClient adminClient, @Nullable CreateTopicsOptions options, @NonNull List<NewTopic> topics) {
        LOG.info("Creating new topics: {}", topics);
        this.result = adminClient.createTopics(topics, options != null ? options : new CreateTopicsOptions());
    }

    @NonNull
    public CreateTopicsResult getResult() {
        return this.result;
    }
}

