/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.serde;

import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.type.Argument;
import java.util.Optional;
import java.util.concurrent.Future;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;

public interface SerdeRegistry
extends Ordered {
    public <T> Serde<T> getSerde(Class<T> var1);

    default public <T> Serializer<T> getSerializer(Class<T> type) {
        return this.getSerde(type).serializer();
    }

    default public <T> Deserializer<T> getDeserializer(Class<T> type) {
        return this.getSerde(type).deserializer();
    }

    default public <T> Deserializer<T> pickDeserializer(Argument<T> argument) {
        Class type = argument.getType();
        if (Publishers.isConvertibleToPublisher((Class)type) || Future.class.isAssignableFrom(type)) {
            Optional typeArg = argument.getFirstTypeVariable();
            if (typeArg.isPresent()) {
                type = ((Argument)typeArg.get()).getType();
            } else {
                return new ByteArrayDeserializer();
            }
        }
        return this.getDeserializer(type);
    }

    default public <T> Serializer<T> pickSerializer(Argument<T> argument) {
        Class type = argument.getType();
        if (Publishers.isConvertibleToPublisher((Class)type) || Future.class.isAssignableFrom(type)) {
            Optional typeArg = argument.getFirstTypeVariable();
            if (typeArg.isPresent()) {
                type = ((Argument)typeArg.get()).getType();
            } else {
                return (Serializer)new ByteArrayDeserializer();
            }
        }
        return this.getSerializer(type);
    }
}

