/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.config;

import io.micronaut.configuration.kafka.config.AbstractKafkaConfiguration;
import io.micronaut.core.annotation.Nullable;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;

public abstract class AbstractKafkaProducerConfiguration<K, V>
extends AbstractKafkaConfiguration<K, V> {
    static final Class DEFAULT_KEY_SERIALIZER = StringSerializer.class;
    static final Class DEFAULT_VALUE_SERIALIZER = StringSerializer.class;
    private Serializer<K> keySerializer;
    private Serializer<V> valueSerializer;
    private String executor;

    protected AbstractKafkaProducerConfiguration(Properties config) {
        super(config);
    }

    public Optional<Serializer<K>> getKeySerializer() {
        return Optional.ofNullable(this.keySerializer);
    }

    public void setKeySerializer(@Nullable Serializer<K> keySerializer) {
        if (keySerializer != null) {
            keySerializer.configure(Utils.propsToMap((Properties)this.getConfig()), true);
        }
        this.keySerializer = keySerializer;
    }

    public Optional<Serializer<V>> getValueSerializer() {
        return Optional.ofNullable(this.valueSerializer);
    }

    public void setValueSerializer(@Nullable Serializer<V> valueSerializer) {
        if (valueSerializer != null) {
            valueSerializer.configure(Utils.propsToMap((Properties)this.getConfig()), false);
        }
        this.valueSerializer = valueSerializer;
    }

    public Optional<String> getExecutor() {
        return Optional.ofNullable(this.executor);
    }

    public void setExecutor(String executor) {
        this.executor = executor;
    }
}

