/*
 * Copyright 2017-2023 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.configuration.kafka.health;

import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.NonNull;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.ClusterResourceListener;

/**
 * {@link FunctionalInterface} to instantiate a {@link NetworkClient}.
 * @since 5.1.0
 */
@FunctionalInterface
@DefaultImplementation(DefaultNetworkClientCreator.class)
public interface NetworkClientCreator {

    /**
     *
     * @param listeners Cluster Resource Listeners
     * @return A Kafka Network Client
     */
    @NonNull
    NetworkClient create(@NonNull ClusterResourceListener... listeners);
}
