/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.bind;

import io.micronaut.configuration.kafka.annotation.KafkaPartition;
import io.micronaut.configuration.kafka.bind.AnnotatedConsumerRecordBinder;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;

@Singleton
public class KafkaPartitionBinder<T>
implements AnnotatedConsumerRecordBinder<KafkaPartition, T> {
    private final ConversionService conversionService;

    public KafkaPartitionBinder(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Class<KafkaPartition> annotationType() {
        return KafkaPartition.class;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, ConsumerRecord<?, ?> source) {
        Integer partition = source.partition();
        Optional converted = this.conversionService.convert((Object)partition, context);
        return () -> converted;
    }
}

