/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.config;

import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.Toggleable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;

public abstract class AbstractKafkaConfiguration<K, V>
implements Toggleable {
    public static final int DEFAULT_KAFKA_PORT = 9092;
    public static final String PREFIX = "kafka";
    public static final String TOPICS = "kafka.topics";
    public static final String EMBEDDED_TOPICS = "kafka.embedded.topics";
    public static final String DEFAULT_BOOTSTRAP_SERVERS = "localhost:9092";
    private final Properties config;

    protected AbstractKafkaConfiguration(Properties config) {
        this.config = config;
    }

    protected static Properties toKafkaProperties(Environment environment, Map<?, ?> values) {
        Properties properties = new Properties();
        values.entrySet().stream().filter(entry -> {
            String key = entry.getKey().toString();
            return Stream.of("embedded", "consumers", "producers", "streams").noneMatch(key::startsWith);
        }).forEach(entry -> {
            Optional converted;
            Object value = entry.getValue();
            if (environment.canConvert(entry.getValue().getClass(), String.class) && (converted = environment.convert(entry.getValue(), String.class)).isPresent()) {
                value = converted.get();
            }
            properties.setProperty(entry.getKey().toString(), value.toString());
        });
        return properties;
    }

    @NonNull
    public Properties getConfig() {
        if (this.config != null) {
            return this.config;
        }
        return new Properties();
    }
}

