/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.config;

import io.micronaut.configuration.kafka.config.AbstractKafkaConfiguration;
import io.micronaut.configuration.kafka.config.AbstractKafkaProducerConfiguration;
import io.micronaut.configuration.kafka.config.KafkaDefaultConfiguration;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Properties;

@Requirements(value={@Requires(missingProperty="kafka.producers.default"), @Requires(beans={KafkaDefaultConfiguration.class})})
@Primary
@Prototype
public class DefaultKafkaProducerConfiguration<K, V>
extends AbstractKafkaProducerConfiguration<K, V> {
    @Inject
    public DefaultKafkaProducerConfiguration(KafkaDefaultConfiguration defaultConfiguration) {
        super(new Properties());
        this.init(defaultConfiguration);
    }

    public DefaultKafkaProducerConfiguration(AbstractKafkaConfiguration defaultConfiguration) {
        super(new Properties());
        this.init(defaultConfiguration);
    }

    private void init(AbstractKafkaConfiguration defaultConfiguration) {
        Properties config = this.getConfig();
        config.putAll((Map<?, ?>)defaultConfiguration.getConfig());
        if (defaultConfiguration instanceof AbstractKafkaProducerConfiguration) {
            AbstractKafkaProducerConfiguration defaultProducerConfig = (AbstractKafkaProducerConfiguration)defaultConfiguration;
            defaultProducerConfig.getKeySerializer().ifPresent(this::setKeySerializer);
            defaultProducerConfig.getValueSerializer().ifPresent(this::setValueSerializer);
            defaultProducerConfig.getExecutor().ifPresent(this::setExecutor);
        }
    }
}

