/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.exceptions;

import io.micronaut.configuration.kafka.config.DefaultKafkaListenerExceptionHandlerConfiguration;
import io.micronaut.configuration.kafka.config.DefaultKafkaListenerExceptionHandlerConfigurationProperties;
import io.micronaut.configuration.kafka.exceptions.KafkaListenerException;
import io.micronaut.configuration.kafka.exceptions.KafkaListenerExceptionHandler;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Primary
public class DefaultKafkaListenerExceptionHandler
implements KafkaListenerExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaListenerExceptionHandler.class);
    private static final Pattern SERIALIZATION_EXCEPTION_MESSAGE_PATTERN = Pattern.compile(".+ for partition (.+)-(\\d+) at offset (\\d+)\\..+");
    private boolean skipRecordOnDeserializationFailure;
    private boolean commitRecordOnDeserializationFailure;

    @Inject
    public DefaultKafkaListenerExceptionHandler(DefaultKafkaListenerExceptionHandlerConfiguration config) {
        this.skipRecordOnDeserializationFailure = config.isSkipRecordOnDeserializationFailure();
        this.commitRecordOnDeserializationFailure = config.isCommitRecordOnDeserializationFailure();
    }

    @Deprecated(since="5.1.0", forRemoval=true)
    public DefaultKafkaListenerExceptionHandler() {
        this(new DefaultKafkaListenerExceptionHandlerConfigurationProperties());
    }

    public void handle(KafkaListenerException exception) {
        Throwable cause = exception.getCause();
        Object consumerBean = exception.getKafkaListener();
        if (cause instanceof SerializationException) {
            LOG.error("Kafka consumer [{}] failed to deserialize value: {}", new Object[]{consumerBean, cause.getMessage(), cause});
            if (this.skipRecordOnDeserializationFailure) {
                Consumer<?, ?> kafkaConsumer = exception.getKafkaConsumer();
                this.seekPastDeserializationError((SerializationException)cause, consumerBean, kafkaConsumer);
            }
        } else if (LOG.isErrorEnabled()) {
            Optional<ConsumerRecord<?, ?>> consumerRecord = exception.getConsumerRecord();
            if (consumerRecord.isPresent()) {
                LOG.error("Error processing record [{}] for Kafka consumer [{}] produced error: {}", new Object[]{consumerRecord, consumerBean, cause.getMessage(), cause});
            } else {
                LOG.error("Kafka consumer [{}] produced error: {}", new Object[]{consumerBean, cause.getMessage(), cause});
            }
        }
    }

    public void setSkipRecordOnDeserializationFailure(boolean skipRecordOnDeserializationFailure) {
        this.skipRecordOnDeserializationFailure = skipRecordOnDeserializationFailure;
    }

    public void setCommitRecordOnDeserializationFailure(boolean commitRecordOnDeserializationFailure) {
        this.commitRecordOnDeserializationFailure = commitRecordOnDeserializationFailure;
    }

    protected void seekPastDeserializationError(@NonNull SerializationException cause, @NonNull Object consumerBean, @NonNull Consumer<?, ?> kafkaConsumer) {
        block7: {
            try {
                String message = cause.getMessage();
                LOG.debug("Extracting unserializable consumer record topic, partition and offset from error message: {}", (Object)message);
                Matcher matcher = SERIALIZATION_EXCEPTION_MESSAGE_PATTERN.matcher(message);
                if (!matcher.find()) break block7;
                String topic = matcher.group(1);
                int partition = Integer.valueOf(matcher.group(2));
                int offset = Integer.valueOf(matcher.group(3));
                TopicPartition tp = new TopicPartition(topic, partition);
                LOG.debug("Seeking past unserializable consumer record for partition {}-{} and offset {}", new Object[]{topic, partition, offset});
                try {
                    kafkaConsumer.seek(tp, (long)(offset + 1));
                }
                catch (Throwable e) {
                    LOG.error("Kafka consumer [{}] failed to seek past unserializable value: {}", new Object[]{consumerBean, e.getMessage(), e});
                }
                if (this.commitRecordOnDeserializationFailure) {
                    try {
                        LOG.debug("Permanently skipping unserializable consumer record by committing offset {} for partition {}-{}", new Object[]{offset, topic, partition});
                        kafkaConsumer.commitSync(Collections.singletonMap(tp, new OffsetAndMetadata((long)(offset + 1))));
                    }
                    catch (Throwable e) {
                        LOG.error("Kafka consumer [{}] failed to commit offset of unserializable value: {}", new Object[]{consumerBean, e.getMessage(), e});
                    }
                }
            }
            catch (Throwable e) {
                LOG.error("Failed to extract topic, partition and offset from serialization error message: {}", (Object)cause.getMessage(), (Object)e);
            }
        }
    }
}

