/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNull;
import io.micronaut.configuration.kafka.metrics.builder.KafkaMetricMeterTypeBuilder;
import io.micronaut.core.annotation.Internal;
import jakarta.annotation.PreDestroy;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsReporter;

@Internal
public abstract class AbstractKafkaMetricsReporter
implements MetricsReporter,
MeterBinder,
Closeable {
    public static final String CLIENT_ID_TAG = "client-id";
    public static final String TOPIC_TAG = "topic";
    public static final String NODE_ID_TAG = "node-id";
    private final Collection<MeterRegistry> meterRegistries = new ConcurrentLinkedQueue<MeterRegistry>();
    private List<KafkaMetric> metrics;

    public void bindTo(@NonNull MeterRegistry registry) {
        if (!this.meterRegistries.contains(registry)) {
            this.meterRegistries.add(registry);
        }
    }

    public void init(List<KafkaMetric> metrics) {
        this.metrics = metrics;
        for (MeterRegistry meterRegistry : this.meterRegistries) {
            for (KafkaMetric metric : metrics) {
                this.registerMetric(meterRegistry, metric);
            }
        }
    }

    public void metricChange(KafkaMetric metric) {
        for (MeterRegistry meterRegistry : this.meterRegistries) {
            this.registerMetric(meterRegistry, metric);
        }
    }

    public void metricRemoval(KafkaMetric metric) {
    }

    public void configure(Map<String, ?> configs) {
        Object meterRegistry = configs.get("meter.registry");
        if (meterRegistry != null) {
            this.meterRegistries.add((MeterRegistry)meterRegistry);
        }
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.metrics != null) {
            this.metrics.clear();
            this.metrics = null;
        }
        this.meterRegistries.clear();
    }

    private void registerMetric(MeterRegistry meterRegistry, KafkaMetric metric) {
        KafkaMetricMeterTypeBuilder.newBuilder().prefix(this.getMetricPrefix()).metric(metric).tagFunction(this.getTagFunction()).registry(meterRegistry).build();
    }

    private Function<MetricName, List<Tag>> getTagFunction() {
        return metricName -> metricName.tags().entrySet().stream().filter(entry -> this.getIncludedTags().contains(entry.getKey())).map(entry -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).toList();
    }

    protected Set<String> getIncludedTags() {
        HashSet<String> tags = new HashSet<String>();
        tags.add(CLIENT_ID_TAG);
        tags.add(TOPIC_TAG);
        tags.add(NODE_ID_TAG);
        return tags;
    }

    protected abstract String getMetricPrefix();
}

