/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.bind;

import io.micronaut.configuration.kafka.bind.AnnotatedConsumerRecordBinder;
import io.micronaut.configuration.kafka.bind.ConsumerRecordBinder;
import io.micronaut.configuration.kafka.bind.KafkaDefaultBinder;
import io.micronaut.configuration.kafka.bind.TypedConsumerRecordBinder;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.ArgumentBinderRegistry;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;

@Singleton
public class ConsumerRecordBinderRegistry
implements ArgumentBinderRegistry<ConsumerRecord<?, ?>> {
    private final Map<Class<? extends Annotation>, ConsumerRecordBinder<?>> byAnnotation = new HashMap();
    private final Map<Integer, ConsumerRecordBinder<?>> byType = new HashMap();

    @Deprecated
    public ConsumerRecordBinderRegistry(ConsumerRecordBinder<?> ... binders) {
        this(ConversionService.SHARED, binders);
    }

    @Inject
    public ConsumerRecordBinderRegistry(ConversionService conversionService, ConsumerRecordBinder<?> ... binders) {
        if (ArrayUtils.isNotEmpty((Object[])binders)) {
            for (ConsumerRecordBinder<?> binder : binders) {
                if (binder instanceof AnnotatedConsumerRecordBinder) {
                    AnnotatedConsumerRecordBinder annotatedConsumerRecordBinder = (AnnotatedConsumerRecordBinder)binder;
                    this.byAnnotation.put(annotatedConsumerRecordBinder.annotationType(), annotatedConsumerRecordBinder);
                    continue;
                }
                if (!(binder instanceof TypedConsumerRecordBinder)) continue;
                TypedConsumerRecordBinder typedConsumerRecordBinder = (TypedConsumerRecordBinder)binder;
                this.byType.put(typedConsumerRecordBinder.argumentType().typeHashCode(), typedConsumerRecordBinder);
            }
        }
    }

    public <T> Optional<ArgumentBinder<T, ConsumerRecord<?, ?>>> findArgumentBinder(Argument<T> argument) {
        Optional annotationType = argument.getAnnotationMetadata().getAnnotationTypeByStereotype(Bindable.class);
        if (annotationType.isPresent()) {
            ConsumerRecordBinder<?> consumerRecordBinder = this.byAnnotation.get(annotationType.get());
            return Optional.ofNullable(consumerRecordBinder);
        }
        ConsumerRecordBinder<?> binder = this.byType.get(argument.typeHashCode());
        return Optional.of((ArgumentBinder)Objects.requireNonNullElseGet(binder, KafkaDefaultBinder::new));
    }
}

