/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.exceptions;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.messaging.exceptions.MessageListenerException;
import java.util.Optional;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;

public class KafkaListenerException
extends MessageListenerException {
    private final transient Object listener;
    private final transient Consumer<?, ?> kafkaConsumer;
    private final transient ConsumerRecords<?, ?> consumerRecords;
    private final transient ConsumerRecord<?, ?> consumerRecord;

    public KafkaListenerException(String message, Object listener, Consumer<?, ?> kafkaConsumer, ConsumerRecord<?, ?> consumerRecord) {
        this(message, null, listener, kafkaConsumer, consumerRecord);
    }

    public KafkaListenerException(String message, Throwable cause, Object listener, Consumer<?, ?> kafkaConsumer, ConsumerRecord<?, ?> consumerRecord) {
        this(message, cause, listener, kafkaConsumer, null, consumerRecord);
    }

    public KafkaListenerException(Throwable cause, Object listener, Consumer<?, ?> kafkaConsumer, ConsumerRecord<?, ?> consumerRecord) {
        this(cause.getMessage(), cause, listener, kafkaConsumer, consumerRecord);
    }

    public KafkaListenerException(String message, Throwable cause, Object listener, Consumer<?, ?> kafkaConsumer, @Nullable ConsumerRecords<?, ?> consumerRecords, @Nullable ConsumerRecord<?, ?> consumerRecord) {
        super(message, cause);
        this.listener = listener;
        this.kafkaConsumer = kafkaConsumer;
        this.consumerRecords = consumerRecords;
        this.consumerRecord = consumerRecord;
    }

    public Object getKafkaListener() {
        return this.listener;
    }

    public Consumer<?, ?> getKafkaConsumer() {
        return this.kafkaConsumer;
    }

    public Optional<ConsumerRecord<?, ?>> getConsumerRecord() {
        return Optional.ofNullable(this.consumerRecord);
    }

    public Optional<ConsumerRecords<?, ?>> getConsumerRecords() {
        return Optional.ofNullable(this.consumerRecords);
    }
}

