/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import io.micronaut.context.env.ActiveEnvironment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.context.env.hocon.ConfigPropertySource;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.order.Ordered;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J,\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J(\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lio/micronaut/context/env/hocon/HoconPropertySourceLoaderImpl;", "Lio/micronaut/context/env/PropertySourceLoader;", "Lio/micronaut/core/order/Ordered;", "()V", "load", "Ljava/util/Optional;", "Lio/micronaut/context/env/PropertySource;", "resourceName", "", "resourceLoader", "Lio/micronaut/core/io/ResourceLoader;", "loadEnv", "activeEnvironment", "Lio/micronaut/context/env/ActiveEnvironment;", "read", "", "", "name", "input", "Ljava/io/InputStream;", "parseConfig", "Lcom/typesafe/config/Config;", "Ljava/net/URL;", "kotlin-runtime"})
public final class HoconPropertySourceLoaderImpl
implements PropertySourceLoader,
Ordered {
    @NotNull
    public Optional<PropertySource> load(@Nullable String resourceName, @Nullable ResourceLoader resourceLoader) {
        return this.loadEnv(resourceName, resourceLoader, null);
    }

    @NotNull
    public Optional<PropertySource> loadEnv(@Nullable String resourceName, @Nullable ResourceLoader resourceLoader, @Nullable ActiveEnvironment activeEnvironment) {
        if (resourceName != null) {
            if (activeEnvironment != null) {
                Optional resource;
                String environmentName = activeEnvironment.getName();
                String qualifiedName = resourceName + '-' + environmentName;
                ResourceLoader resourceLoader2 = resourceLoader;
                Optional optional = resource = resourceLoader2 == null ? null : resourceLoader2.getResource(Intrinsics.stringPlus((String)qualifiedName, (Object)".conf"));
                if (resource != null && resource.isPresent()) {
                    Object object = resource.get();
                    Intrinsics.checkNotNullExpressionValue(object, (String)"resource.get()");
                    Config config = this.parseConfig((URL)object);
                    object = Optional.of(new ConfigPropertySource(qualifiedName, config));
                    Intrinsics.checkNotNullExpressionValue(object, (String)"of(ConfigPropertySource(qualifiedName, config))");
                    return object;
                }
            } else {
                Optional resource;
                ResourceLoader qualifiedName = resourceLoader;
                Optional optional = resource = qualifiedName == null ? null : qualifiedName.getResource(Intrinsics.stringPlus((String)resourceName, (Object)".conf"));
                if (resource != null && resource.isPresent()) {
                    Object object = resource.get();
                    Intrinsics.checkNotNullExpressionValue(object, (String)"resource.get()");
                    Config config = this.parseConfig((URL)object);
                    object = Optional.of(new ConfigPropertySource(resourceName, config));
                    Intrinsics.checkNotNullExpressionValue(object, (String)"of(ConfigPropertySource(resourceName, config))");
                    return object;
                }
            }
        }
        Optional<PropertySource> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
        return optional;
    }

    @NotNull
    public Map<String, Object> read(@Nullable String name, @Nullable InputStream input) {
        Config config = ConfigFactory.parseReader((Reader)new InputStreamReader(input, StandardCharsets.UTF_8));
        if (name != null) {
            Set entrySet = config.entrySet();
            Map map = new LinkedHashMap();
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                ConfigValue value = (ConfigValue)entry.getValue();
                Map map2 = map;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                String string = key;
                Object object = value.unwrapped();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value.unwrapped()");
                boolean bl = false;
                map2.put(string, object);
            }
            return map;
        }
        Map<String, Object> map = Collections.emptyMap();
        Intrinsics.checkNotNullExpressionValue(map, (String)"emptyMap()");
        return map;
    }

    private final Config parseConfig(URL $this$parseConfig) {
        Config config = ConfigFactory.parseURL((URL)$this$parseConfig).resolve();
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"parseURL(this)\n                    .resolve()");
        return config;
    }
}

