/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.client.DefaultHttpClientConfiguration;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.ssl.ClientSslConfiguration;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Inject;

@BootstrapContextCompatible
@ConfigurationProperties(value="micronaut.http.client.kubernetes")
final class KubernetesHttpClientConfiguration
extends HttpClientConfiguration {
    static final String PREFIX = "micronaut.http.client.kubernetes";
    private final HttpClientConfiguration.ConnectionPoolConfiguration connectionPoolConfiguration;
    private final HttpClientConfiguration.WebSocketCompressionConfiguration webSocketCompressionConfiguration;
    private final HttpClientConfiguration.Http2ClientConfiguration http2ClientConfiguration;

    KubernetesHttpClientConfiguration(@Nullable DefaultHttpClientConfiguration.DefaultConnectionPoolConfiguration defaultConnectionPoolConfiguration, @Nullable DefaultHttpClientConfiguration.DefaultWebSocketCompressionConfiguration defaultWebSocketCompressionConfiguration, @Nullable DefaultHttpClientConfiguration.DefaultHttp2ClientConfiguration defaultHttp2ClientConfiguration, @Nullable ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
        this.connectionPoolConfiguration = defaultConnectionPoolConfiguration == null ? new DefaultHttpClientConfiguration.DefaultConnectionPoolConfiguration() : defaultConnectionPoolConfiguration;
        this.webSocketCompressionConfiguration = defaultWebSocketCompressionConfiguration == null ? new DefaultHttpClientConfiguration.DefaultWebSocketCompressionConfiguration() : defaultWebSocketCompressionConfiguration;
        this.http2ClientConfiguration = defaultHttp2ClientConfiguration == null ? new DefaultHttpClientConfiguration.DefaultHttp2ClientConfiguration() : defaultHttp2ClientConfiguration;
    }

    @Inject
    public void setClientSslConfiguration(@Nullable ClientSslConfiguration sslConfiguration) {
        if (sslConfiguration != null) {
            super.setSslConfiguration((SslConfiguration)sslConfiguration);
        }
    }

    public HttpClientConfiguration.ConnectionPoolConfiguration getConnectionPoolConfiguration() {
        return this.connectionPoolConfiguration;
    }

    public HttpClientConfiguration.WebSocketCompressionConfiguration getWebSocketCompressionConfiguration() {
        return this.webSocketCompressionConfiguration;
    }

    public HttpClientConfiguration.Http2ClientConfiguration getHttp2Configuration() {
        return this.http2ClientConfiguration;
    }
}

