/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.credential;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.kubernetes.client.openapi.config.KubeConfig;
import io.micronaut.kubernetes.client.openapi.config.KubeConfigLoader;
import io.micronaut.kubernetes.client.openapi.credential.ReactiveKubernetesTokenLoader;
import jakarta.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Singleton
@BootstrapContextCompatible
@Internal
final class KubeConfigTokenLoader
implements ReactiveKubernetesTokenLoader {
    private static final Logger LOG = LoggerFactory.getLogger(KubeConfigTokenLoader.class);
    private static final int ORDER = 20;
    private final String token;

    KubeConfigTokenLoader(KubeConfigLoader kubeConfigLoader) {
        KubeConfig kubeConfig = kubeConfigLoader.getKubeConfig();
        this.token = kubeConfig == null || kubeConfig.getUser() == null ? null : kubeConfig.getUser().token();
    }

    public int getOrder() {
        return 20;
    }

    @Override
    public Publisher<String> getToken() {
        return StringUtils.isEmpty((CharSequence)this.token) ? Mono.empty() : Mono.just((Object)this.token).doOnNext(it -> LOG.trace("Token loaded"));
    }
}

