/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.credential.model;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Objects;

@Serdeable.Deserializable
public record ExecCredentialStatus(@NonNull String token, @Nullable byte[] clientCertificateData, @Nullable byte[] clientKeyData, @Nullable ZonedDateTime expirationTimestamp) {
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecCredentialStatus that = (ExecCredentialStatus)o;
        return Objects.equals(this.token, that.token) && Arrays.equals(this.clientCertificateData, that.clientCertificateData) && Arrays.equals(this.clientKeyData, that.clientKeyData) && Objects.equals(this.expirationTimestamp, that.expirationTimestamp);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.token, this.expirationTimestamp);
        result = 31 * result + Arrays.hashCode(this.clientCertificateData);
        result = 31 * result + Arrays.hashCode(this.clientKeyData);
        return result;
    }

    @Override
    public String toString() {
        return "ExecCredentialStatus{token='" + this.token + "', clientCertificateData=" + Arrays.toString(this.clientCertificateData) + ", clientKeyData=" + Arrays.toString(this.clientKeyData) + ", expirationTimestamp=" + String.valueOf(this.expirationTimestamp) + "}";
    }
}

