/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"audience", "expirationSeconds"})
public class StorageV1TokenRequest {
    public static final String JSON_PROPERTY_AUDIENCE = "audience";
    public static final String JSON_PROPERTY_EXPIRATION_SECONDS = "expirationSeconds";
    @NotNull
    @JsonProperty(value="audience")
    private String audience;
    @Nullable
    @JsonProperty(value="expirationSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Long expirationSeconds;

    public StorageV1TokenRequest(String audience) {
        this.audience = audience;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public StorageV1TokenRequest audience(String audience) {
        this.audience = audience;
        return this;
    }

    public Long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public void setExpirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
    }

    public StorageV1TokenRequest expirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageV1TokenRequest storageV1TokenRequest = (StorageV1TokenRequest)o;
        return Objects.equals(this.audience, storageV1TokenRequest.audience) && Objects.equals(this.expirationSeconds, storageV1TokenRequest.expirationSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.audience, this.expirationSeconds);
    }

    public String toString() {
        return "StorageV1TokenRequest(audience: " + this.getAudience() + ", expirationSeconds: " + this.getExpirationSeconds() + ")";
    }
}

