/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1APIGroup;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"groups", "apiVersion", "kind"})
public class V1APIGroupList {
    public static final String JSON_PROPERTY_GROUPS = "groups";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    @NotNull
    @JsonProperty(value="groups")
    private @NotNull List<@Valid V1APIGroup> groups;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;

    public V1APIGroupList(List<@Valid V1APIGroup> groups) {
        this.groups = groups;
    }

    public List<@Valid V1APIGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<@Valid V1APIGroup> groups) {
        this.groups = groups;
    }

    public V1APIGroupList groups(List<@Valid V1APIGroup> groups) {
        this.groups = groups;
        return this;
    }

    public V1APIGroupList addGroupsItem(V1APIGroup groupsItem) {
        this.groups.add(groupsItem);
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1APIGroupList apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1APIGroupList kind(String kind) {
        this.kind = kind;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIGroupList v1APIGroupList = (V1APIGroupList)o;
        return Objects.equals(this.groups, v1APIGroupList.groups) && Objects.equals(this.apiVersion, v1APIGroupList.apiVersion) && Objects.equals(this.kind, v1APIGroupList.kind);
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.apiVersion, this.kind);
    }

    public String toString() {
        return "V1APIGroupList(groups: " + String.valueOf(this.getGroups()) + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ")";
    }
}

