/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"kind", "name", "namespaced", "singularName", "verbs", "categories", "group", "shortNames", "storageVersionHash", "version"})
public class V1APIResource {
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_NAME = "name";
    public static final String JSON_PROPERTY_NAMESPACED = "namespaced";
    public static final String JSON_PROPERTY_SINGULAR_NAME = "singularName";
    public static final String JSON_PROPERTY_VERBS = "verbs";
    public static final String JSON_PROPERTY_CATEGORIES = "categories";
    public static final String JSON_PROPERTY_GROUP = "group";
    public static final String JSON_PROPERTY_SHORT_NAMES = "shortNames";
    public static final String JSON_PROPERTY_STORAGE_VERSION_HASH = "storageVersionHash";
    public static final String JSON_PROPERTY_VERSION = "version";
    @NotNull
    @JsonProperty(value="kind")
    private String kind;
    @NotNull
    @JsonProperty(value="name")
    private String name;
    @NotNull
    @JsonProperty(value="namespaced")
    private Boolean namespaced;
    @NotNull
    @JsonProperty(value="singularName")
    private String singularName;
    @NotNull
    @JsonProperty(value="verbs")
    private @NotNull List<@NotNull String> verbs;
    @Nullable
    @JsonProperty(value="categories")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> categories;
    @Nullable
    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String group;
    @Nullable
    @JsonProperty(value="shortNames")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> shortNames;
    @Nullable
    @JsonProperty(value="storageVersionHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String storageVersionHash;
    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String version;

    public V1APIResource(String kind, String name, Boolean namespaced, String singularName, List<@NotNull String> verbs) {
        this.kind = kind;
        this.name = name;
        this.namespaced = namespaced;
        this.singularName = singularName;
        this.verbs = verbs;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1APIResource kind(String kind) {
        this.kind = kind;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1APIResource name(String name) {
        this.name = name;
        return this;
    }

    public Boolean getNamespaced() {
        return this.namespaced;
    }

    public void setNamespaced(Boolean namespaced) {
        this.namespaced = namespaced;
    }

    public V1APIResource namespaced(Boolean namespaced) {
        this.namespaced = namespaced;
        return this;
    }

    public String getSingularName() {
        return this.singularName;
    }

    public void setSingularName(String singularName) {
        this.singularName = singularName;
    }

    public V1APIResource singularName(String singularName) {
        this.singularName = singularName;
        return this;
    }

    public List<@NotNull String> getVerbs() {
        return this.verbs;
    }

    public void setVerbs(List<@NotNull String> verbs) {
        this.verbs = verbs;
    }

    public V1APIResource verbs(List<@NotNull String> verbs) {
        this.verbs = verbs;
        return this;
    }

    public V1APIResource addVerbsItem(String verbsItem) {
        this.verbs.add(verbsItem);
        return this;
    }

    public List<@NotNull String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<@NotNull String> categories) {
        this.categories = categories;
    }

    public V1APIResource categories(List<@NotNull String> categories) {
        this.categories = categories;
        return this;
    }

    public V1APIResource addCategoriesItem(String categoriesItem) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        this.categories.add(categoriesItem);
        return this;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public V1APIResource group(String group) {
        this.group = group;
        return this;
    }

    public List<@NotNull String> getShortNames() {
        return this.shortNames;
    }

    public void setShortNames(List<@NotNull String> shortNames) {
        this.shortNames = shortNames;
    }

    public V1APIResource shortNames(List<@NotNull String> shortNames) {
        this.shortNames = shortNames;
        return this;
    }

    public V1APIResource addShortNamesItem(String shortNamesItem) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        this.shortNames.add(shortNamesItem);
        return this;
    }

    public String getStorageVersionHash() {
        return this.storageVersionHash;
    }

    public void setStorageVersionHash(String storageVersionHash) {
        this.storageVersionHash = storageVersionHash;
    }

    public V1APIResource storageVersionHash(String storageVersionHash) {
        this.storageVersionHash = storageVersionHash;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public V1APIResource version(String version) {
        this.version = version;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIResource v1APIResource = (V1APIResource)o;
        return Objects.equals(this.kind, v1APIResource.kind) && Objects.equals(this.name, v1APIResource.name) && Objects.equals(this.namespaced, v1APIResource.namespaced) && Objects.equals(this.singularName, v1APIResource.singularName) && Objects.equals(this.verbs, v1APIResource.verbs) && Objects.equals(this.categories, v1APIResource.categories) && Objects.equals(this.group, v1APIResource.group) && Objects.equals(this.shortNames, v1APIResource.shortNames) && Objects.equals(this.storageVersionHash, v1APIResource.storageVersionHash) && Objects.equals(this.version, v1APIResource.version);
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.name, this.namespaced, this.singularName, this.verbs, this.categories, this.group, this.shortNames, this.storageVersionHash, this.version);
    }

    public String toString() {
        return "V1APIResource(kind: " + this.getKind() + ", name: " + this.getName() + ", namespaced: " + this.getNamespaced() + ", singularName: " + this.getSingularName() + ", verbs: " + String.valueOf(this.getVerbs()) + ", categories: " + String.valueOf(this.getCategories()) + ", group: " + this.getGroup() + ", shortNames: " + String.valueOf(this.getShortNames()) + ", storageVersionHash: " + this.getStorageVersionHash() + ", version: " + this.getVersion() + ")";
    }
}

