/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.common.KubernetesObject;
import io.micronaut.kubernetes.client.openapi.model.V1LabelSelector;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"storageClassName", "apiVersion", "capacity", "kind", "maximumVolumeSize", "metadata", "nodeTopology"})
public class V1CSIStorageCapacity
implements KubernetesObject {
    public static final String JSON_PROPERTY_STORAGE_CLASS_NAME = "storageClassName";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_CAPACITY = "capacity";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_MAXIMUM_VOLUME_SIZE = "maximumVolumeSize";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    public static final String JSON_PROPERTY_NODE_TOPOLOGY = "nodeTopology";
    @NotNull
    @JsonProperty(value="storageClassName")
    private String storageClassName;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="capacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String capacity;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @JsonProperty(value="maximumVolumeSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String maximumVolumeSize;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;
    @Nullable
    @Valid
    @JsonProperty(value="nodeTopology")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1LabelSelector nodeTopology;

    public V1CSIStorageCapacity(String storageClassName) {
        this.storageClassName = storageClassName;
    }

    public String getStorageClassName() {
        return this.storageClassName;
    }

    public void setStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
    }

    public V1CSIStorageCapacity storageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return this;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1CSIStorageCapacity apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getCapacity() {
        return this.capacity;
    }

    public void setCapacity(String capacity) {
        this.capacity = capacity;
    }

    public V1CSIStorageCapacity capacity(String capacity) {
        this.capacity = capacity;
        return this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1CSIStorageCapacity kind(String kind) {
        this.kind = kind;
        return this;
    }

    public String getMaximumVolumeSize() {
        return this.maximumVolumeSize;
    }

    public void setMaximumVolumeSize(String maximumVolumeSize) {
        this.maximumVolumeSize = maximumVolumeSize;
    }

    public V1CSIStorageCapacity maximumVolumeSize(String maximumVolumeSize) {
        this.maximumVolumeSize = maximumVolumeSize;
        return this;
    }

    @Override
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1CSIStorageCapacity metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public V1LabelSelector getNodeTopology() {
        return this.nodeTopology;
    }

    public void setNodeTopology(V1LabelSelector nodeTopology) {
        this.nodeTopology = nodeTopology;
    }

    public V1CSIStorageCapacity nodeTopology(V1LabelSelector nodeTopology) {
        this.nodeTopology = nodeTopology;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CSIStorageCapacity v1CSIStorageCapacity = (V1CSIStorageCapacity)o;
        return Objects.equals(this.storageClassName, v1CSIStorageCapacity.storageClassName) && Objects.equals(this.apiVersion, v1CSIStorageCapacity.apiVersion) && Objects.equals(this.capacity, v1CSIStorageCapacity.capacity) && Objects.equals(this.kind, v1CSIStorageCapacity.kind) && Objects.equals(this.maximumVolumeSize, v1CSIStorageCapacity.maximumVolumeSize) && Objects.equals(this.metadata, v1CSIStorageCapacity.metadata) && Objects.equals(this.nodeTopology, v1CSIStorageCapacity.nodeTopology);
    }

    public int hashCode() {
        return Objects.hash(this.storageClassName, this.apiVersion, this.capacity, this.kind, this.maximumVolumeSize, this.metadata, this.nodeTopology);
    }

    public String toString() {
        return "V1CSIStorageCapacity(storageClassName: " + this.getStorageClassName() + ", apiVersion: " + this.getApiVersion() + ", capacity: " + this.getCapacity() + ", kind: " + this.getKind() + ", maximumVolumeSize: " + this.getMaximumVolumeSize() + ", metadata: " + String.valueOf(this.getMetadata()) + ", nodeTopology: " + String.valueOf(this.getNodeTopology()) + ")";
    }
}

