/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.common.KubernetesObject;
import io.micronaut.kubernetes.client.openapi.model.V1AggregationRule;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.kubernetes.client.openapi.model.V1PolicyRule;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"aggregationRule", "apiVersion", "kind", "metadata", "rules"})
public class V1ClusterRole
implements KubernetesObject {
    public static final String JSON_PROPERTY_AGGREGATION_RULE = "aggregationRule";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    public static final String JSON_PROPERTY_RULES = "rules";
    @Nullable
    @Valid
    @JsonProperty(value="aggregationRule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1AggregationRule aggregationRule;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;
    @Nullable
    @JsonProperty(value="rules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1PolicyRule> rules;

    public V1AggregationRule getAggregationRule() {
        return this.aggregationRule;
    }

    public void setAggregationRule(V1AggregationRule aggregationRule) {
        this.aggregationRule = aggregationRule;
    }

    public V1ClusterRole aggregationRule(V1AggregationRule aggregationRule) {
        this.aggregationRule = aggregationRule;
        return this;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1ClusterRole apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1ClusterRole kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1ClusterRole metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<@Valid V1PolicyRule> getRules() {
        return this.rules;
    }

    public void setRules(List<@Valid V1PolicyRule> rules) {
        this.rules = rules;
    }

    public V1ClusterRole rules(List<@Valid V1PolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public V1ClusterRole addRulesItem(V1PolicyRule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1PolicyRule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ClusterRole v1ClusterRole = (V1ClusterRole)o;
        return Objects.equals(this.aggregationRule, v1ClusterRole.aggregationRule) && Objects.equals(this.apiVersion, v1ClusterRole.apiVersion) && Objects.equals(this.kind, v1ClusterRole.kind) && Objects.equals(this.metadata, v1ClusterRole.metadata) && Objects.equals(this.rules, v1ClusterRole.rules);
    }

    public int hashCode() {
        return Objects.hash(this.aggregationRule, this.apiVersion, this.kind, this.metadata, this.rules);
    }

    public String toString() {
        return "V1ClusterRole(aggregationRule: " + String.valueOf(this.getAggregationRule()) + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", metadata: " + String.valueOf(this.getMetadata()) + ", rules: " + String.valueOf(this.getRules()) + ")";
    }
}

