/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1ContainerPort;
import io.micronaut.kubernetes.client.openapi.model.V1ContainerResizePolicy;
import io.micronaut.kubernetes.client.openapi.model.V1EnvFromSource;
import io.micronaut.kubernetes.client.openapi.model.V1EnvVar;
import io.micronaut.kubernetes.client.openapi.model.V1Lifecycle;
import io.micronaut.kubernetes.client.openapi.model.V1Probe;
import io.micronaut.kubernetes.client.openapi.model.V1ResourceRequirements;
import io.micronaut.kubernetes.client.openapi.model.V1SecurityContext;
import io.micronaut.kubernetes.client.openapi.model.V1VolumeDevice;
import io.micronaut.kubernetes.client.openapi.model.V1VolumeMount;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"name", "args", "command", "env", "envFrom", "image", "imagePullPolicy", "lifecycle", "livenessProbe", "ports", "readinessProbe", "resizePolicy", "resources", "restartPolicy", "securityContext", "startupProbe", "stdin", "stdinOnce", "terminationMessagePath", "terminationMessagePolicy", "tty", "volumeDevices", "volumeMounts", "workingDir"})
public class V1Container {
    public static final String JSON_PROPERTY_NAME = "name";
    public static final String JSON_PROPERTY_ARGS = "args";
    public static final String JSON_PROPERTY_COMMAND = "command";
    public static final String JSON_PROPERTY_ENV = "env";
    public static final String JSON_PROPERTY_ENV_FROM = "envFrom";
    public static final String JSON_PROPERTY_IMAGE = "image";
    public static final String JSON_PROPERTY_IMAGE_PULL_POLICY = "imagePullPolicy";
    public static final String JSON_PROPERTY_LIFECYCLE = "lifecycle";
    public static final String JSON_PROPERTY_LIVENESS_PROBE = "livenessProbe";
    public static final String JSON_PROPERTY_PORTS = "ports";
    public static final String JSON_PROPERTY_READINESS_PROBE = "readinessProbe";
    public static final String JSON_PROPERTY_RESIZE_POLICY = "resizePolicy";
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    public static final String JSON_PROPERTY_RESTART_POLICY = "restartPolicy";
    public static final String JSON_PROPERTY_SECURITY_CONTEXT = "securityContext";
    public static final String JSON_PROPERTY_STARTUP_PROBE = "startupProbe";
    public static final String JSON_PROPERTY_STDIN = "stdin";
    public static final String JSON_PROPERTY_STDIN_ONCE = "stdinOnce";
    public static final String JSON_PROPERTY_TERMINATION_MESSAGE_PATH = "terminationMessagePath";
    public static final String JSON_PROPERTY_TERMINATION_MESSAGE_POLICY = "terminationMessagePolicy";
    public static final String JSON_PROPERTY_TTY = "tty";
    public static final String JSON_PROPERTY_VOLUME_DEVICES = "volumeDevices";
    public static final String JSON_PROPERTY_VOLUME_MOUNTS = "volumeMounts";
    public static final String JSON_PROPERTY_WORKING_DIR = "workingDir";
    @NotNull
    @JsonProperty(value="name")
    private String name;
    @Nullable
    @JsonProperty(value="args")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> args;
    @Nullable
    @JsonProperty(value="command")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@NotNull String> command;
    @Nullable
    @JsonProperty(value="env")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1EnvVar> env;
    @Nullable
    @JsonProperty(value="envFrom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1EnvFromSource> envFrom;
    @Nullable
    @JsonProperty(value="image")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String image;
    @Nullable
    @JsonProperty(value="imagePullPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String imagePullPolicy;
    @Nullable
    @Valid
    @JsonProperty(value="lifecycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1Lifecycle lifecycle;
    @Nullable
    @Valid
    @JsonProperty(value="livenessProbe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1Probe livenessProbe;
    @Nullable
    @JsonProperty(value="ports")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ContainerPort> ports;
    @Nullable
    @Valid
    @JsonProperty(value="readinessProbe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1Probe readinessProbe;
    @Nullable
    @JsonProperty(value="resizePolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ContainerResizePolicy> resizePolicy;
    @Nullable
    @Valid
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ResourceRequirements resources;
    @Nullable
    @JsonProperty(value="restartPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String restartPolicy;
    @Nullable
    @Valid
    @JsonProperty(value="securityContext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1SecurityContext securityContext;
    @Nullable
    @Valid
    @JsonProperty(value="startupProbe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1Probe startupProbe;
    @Nullable
    @JsonProperty(value="stdin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean stdin;
    @Nullable
    @JsonProperty(value="stdinOnce")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean stdinOnce;
    @Nullable
    @JsonProperty(value="terminationMessagePath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String terminationMessagePath;
    @Nullable
    @JsonProperty(value="terminationMessagePolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String terminationMessagePolicy;
    @Nullable
    @JsonProperty(value="tty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean tty;
    @Nullable
    @JsonProperty(value="volumeDevices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1VolumeDevice> volumeDevices;
    @Nullable
    @JsonProperty(value="volumeMounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1VolumeMount> volumeMounts;
    @Nullable
    @JsonProperty(value="workingDir")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String workingDir;

    public V1Container(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1Container name(String name) {
        this.name = name;
        return this;
    }

    public List<@NotNull String> getArgs() {
        return this.args;
    }

    public void setArgs(List<@NotNull String> args) {
        this.args = args;
    }

    public V1Container args(List<@NotNull String> args) {
        this.args = args;
        return this;
    }

    public V1Container addArgsItem(String argsItem) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(argsItem);
        return this;
    }

    public List<@NotNull String> getCommand() {
        return this.command;
    }

    public void setCommand(List<@NotNull String> command) {
        this.command = command;
    }

    public V1Container command(List<@NotNull String> command) {
        this.command = command;
        return this;
    }

    public V1Container addCommandItem(String commandItem) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(commandItem);
        return this;
    }

    public List<@Valid V1EnvVar> getEnv() {
        return this.env;
    }

    public void setEnv(List<@Valid V1EnvVar> env) {
        this.env = env;
    }

    public V1Container env(List<@Valid V1EnvVar> env) {
        this.env = env;
        return this;
    }

    public V1Container addEnvItem(V1EnvVar envItem) {
        if (this.env == null) {
            this.env = new ArrayList<V1EnvVar>();
        }
        this.env.add(envItem);
        return this;
    }

    public List<@Valid V1EnvFromSource> getEnvFrom() {
        return this.envFrom;
    }

    public void setEnvFrom(List<@Valid V1EnvFromSource> envFrom) {
        this.envFrom = envFrom;
    }

    public V1Container envFrom(List<@Valid V1EnvFromSource> envFrom) {
        this.envFrom = envFrom;
        return this;
    }

    public V1Container addEnvFromItem(V1EnvFromSource envFromItem) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<V1EnvFromSource>();
        }
        this.envFrom.add(envFromItem);
        return this;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public V1Container image(String image) {
        this.image = image;
        return this;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public V1Container imagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return this;
    }

    public V1Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(V1Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public V1Container lifecycle(V1Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
        return this;
    }

    public V1Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    public void setLivenessProbe(V1Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    public V1Container livenessProbe(V1Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
        return this;
    }

    public List<@Valid V1ContainerPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<@Valid V1ContainerPort> ports) {
        this.ports = ports;
    }

    public V1Container ports(List<@Valid V1ContainerPort> ports) {
        this.ports = ports;
        return this;
    }

    public V1Container addPortsItem(V1ContainerPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1ContainerPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    public V1Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    public void setReadinessProbe(V1Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    public V1Container readinessProbe(V1Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
        return this;
    }

    public List<@Valid V1ContainerResizePolicy> getResizePolicy() {
        return this.resizePolicy;
    }

    public void setResizePolicy(List<@Valid V1ContainerResizePolicy> resizePolicy) {
        this.resizePolicy = resizePolicy;
    }

    public V1Container resizePolicy(List<@Valid V1ContainerResizePolicy> resizePolicy) {
        this.resizePolicy = resizePolicy;
        return this;
    }

    public V1Container addResizePolicyItem(V1ContainerResizePolicy resizePolicyItem) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList<V1ContainerResizePolicy>();
        }
        this.resizePolicy.add(resizePolicyItem);
        return this;
    }

    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public V1Container resources(V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public V1Container restartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    public V1SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(V1SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public V1Container securityContext(V1SecurityContext securityContext) {
        this.securityContext = securityContext;
        return this;
    }

    public V1Probe getStartupProbe() {
        return this.startupProbe;
    }

    public void setStartupProbe(V1Probe startupProbe) {
        this.startupProbe = startupProbe;
    }

    public V1Container startupProbe(V1Probe startupProbe) {
        this.startupProbe = startupProbe;
        return this;
    }

    public Boolean getStdin() {
        return this.stdin;
    }

    public void setStdin(Boolean stdin) {
        this.stdin = stdin;
    }

    public V1Container stdin(Boolean stdin) {
        this.stdin = stdin;
        return this;
    }

    public Boolean getStdinOnce() {
        return this.stdinOnce;
    }

    public void setStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
    }

    public V1Container stdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return this;
    }

    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    public void setTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
    }

    public V1Container terminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
        return this;
    }

    public String getTerminationMessagePolicy() {
        return this.terminationMessagePolicy;
    }

    public void setTerminationMessagePolicy(String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
    }

    public V1Container terminationMessagePolicy(String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
        return this;
    }

    public Boolean getTty() {
        return this.tty;
    }

    public void setTty(Boolean tty) {
        this.tty = tty;
    }

    public V1Container tty(Boolean tty) {
        this.tty = tty;
        return this;
    }

    public List<@Valid V1VolumeDevice> getVolumeDevices() {
        return this.volumeDevices;
    }

    public void setVolumeDevices(List<@Valid V1VolumeDevice> volumeDevices) {
        this.volumeDevices = volumeDevices;
    }

    public V1Container volumeDevices(List<@Valid V1VolumeDevice> volumeDevices) {
        this.volumeDevices = volumeDevices;
        return this;
    }

    public V1Container addVolumeDevicesItem(V1VolumeDevice volumeDevicesItem) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList<V1VolumeDevice>();
        }
        this.volumeDevices.add(volumeDevicesItem);
        return this;
    }

    public List<@Valid V1VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(List<@Valid V1VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    public V1Container volumeMounts(List<@Valid V1VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public V1Container addVolumeMountsItem(V1VolumeMount volumeMountsItem) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<V1VolumeMount>();
        }
        this.volumeMounts.add(volumeMountsItem);
        return this;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public V1Container workingDir(String workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Container v1Container = (V1Container)o;
        return Objects.equals(this.name, v1Container.name) && Objects.equals(this.args, v1Container.args) && Objects.equals(this.command, v1Container.command) && Objects.equals(this.env, v1Container.env) && Objects.equals(this.envFrom, v1Container.envFrom) && Objects.equals(this.image, v1Container.image) && Objects.equals(this.imagePullPolicy, v1Container.imagePullPolicy) && Objects.equals(this.lifecycle, v1Container.lifecycle) && Objects.equals(this.livenessProbe, v1Container.livenessProbe) && Objects.equals(this.ports, v1Container.ports) && Objects.equals(this.readinessProbe, v1Container.readinessProbe) && Objects.equals(this.resizePolicy, v1Container.resizePolicy) && Objects.equals(this.resources, v1Container.resources) && Objects.equals(this.restartPolicy, v1Container.restartPolicy) && Objects.equals(this.securityContext, v1Container.securityContext) && Objects.equals(this.startupProbe, v1Container.startupProbe) && Objects.equals(this.stdin, v1Container.stdin) && Objects.equals(this.stdinOnce, v1Container.stdinOnce) && Objects.equals(this.terminationMessagePath, v1Container.terminationMessagePath) && Objects.equals(this.terminationMessagePolicy, v1Container.terminationMessagePolicy) && Objects.equals(this.tty, v1Container.tty) && Objects.equals(this.volumeDevices, v1Container.volumeDevices) && Objects.equals(this.volumeMounts, v1Container.volumeMounts) && Objects.equals(this.workingDir, v1Container.workingDir);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.args, this.command, this.env, this.envFrom, this.image, this.imagePullPolicy, this.lifecycle, this.livenessProbe, this.ports, this.readinessProbe, this.resizePolicy, this.resources, this.restartPolicy, this.securityContext, this.startupProbe, this.stdin, this.stdinOnce, this.terminationMessagePath, this.terminationMessagePolicy, this.tty, this.volumeDevices, this.volumeMounts, this.workingDir);
    }

    public String toString() {
        return "V1Container(name: " + this.getName() + ", args: " + String.valueOf(this.getArgs()) + ", command: " + String.valueOf(this.getCommand()) + ", env: " + String.valueOf(this.getEnv()) + ", envFrom: " + String.valueOf(this.getEnvFrom()) + ", image: " + this.getImage() + ", imagePullPolicy: " + this.getImagePullPolicy() + ", lifecycle: " + String.valueOf(this.getLifecycle()) + ", livenessProbe: " + String.valueOf(this.getLivenessProbe()) + ", ports: " + String.valueOf(this.getPorts()) + ", readinessProbe: " + String.valueOf(this.getReadinessProbe()) + ", resizePolicy: " + String.valueOf(this.getResizePolicy()) + ", resources: " + String.valueOf(this.getResources()) + ", restartPolicy: " + this.getRestartPolicy() + ", securityContext: " + String.valueOf(this.getSecurityContext()) + ", startupProbe: " + String.valueOf(this.getStartupProbe()) + ", stdin: " + this.getStdin() + ", stdinOnce: " + this.getStdinOnce() + ", terminationMessagePath: " + this.getTerminationMessagePath() + ", terminationMessagePolicy: " + this.getTerminationMessagePolicy() + ", tty: " + this.getTty() + ", volumeDevices: " + String.valueOf(this.getVolumeDevices()) + ", volumeMounts: " + String.valueOf(this.getVolumeMounts()) + ", workingDir: " + this.getWorkingDir() + ")";
    }
}

