/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1ContainerState;
import io.micronaut.kubernetes.client.openapi.model.V1ContainerUser;
import io.micronaut.kubernetes.client.openapi.model.V1ResourceRequirements;
import io.micronaut.kubernetes.client.openapi.model.V1ResourceStatus;
import io.micronaut.kubernetes.client.openapi.model.V1VolumeMountStatus;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"image", "imageID", "name", "ready", "restartCount", "allocatedResources", "allocatedResourcesStatus", "containerID", "lastState", "resources", "started", "state", "user", "volumeMounts"})
public class V1ContainerStatus {
    public static final String JSON_PROPERTY_IMAGE = "image";
    public static final String JSON_PROPERTY_IMAGE_I_D = "imageID";
    public static final String JSON_PROPERTY_NAME = "name";
    public static final String JSON_PROPERTY_READY = "ready";
    public static final String JSON_PROPERTY_RESTART_COUNT = "restartCount";
    public static final String JSON_PROPERTY_ALLOCATED_RESOURCES = "allocatedResources";
    public static final String JSON_PROPERTY_ALLOCATED_RESOURCES_STATUS = "allocatedResourcesStatus";
    public static final String JSON_PROPERTY_CONTAINER_I_D = "containerID";
    public static final String JSON_PROPERTY_LAST_STATE = "lastState";
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    public static final String JSON_PROPERTY_STARTED = "started";
    public static final String JSON_PROPERTY_STATE = "state";
    public static final String JSON_PROPERTY_USER = "user";
    public static final String JSON_PROPERTY_VOLUME_MOUNTS = "volumeMounts";
    @NotNull
    @JsonProperty(value="image")
    private String image;
    @NotNull
    @JsonProperty(value="imageID")
    private String imageID;
    @NotNull
    @JsonProperty(value="name")
    private String name;
    @NotNull
    @JsonProperty(value="ready")
    private Boolean ready;
    @NotNull
    @JsonProperty(value="restartCount")
    private Integer restartCount;
    @Nullable
    @JsonProperty(value="allocatedResources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> allocatedResources;
    @Nullable
    @JsonProperty(value="allocatedResourcesStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1ResourceStatus> allocatedResourcesStatus;
    @Nullable
    @JsonProperty(value="containerID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String containerID;
    @Nullable
    @Valid
    @JsonProperty(value="lastState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ContainerState lastState;
    @Nullable
    @Valid
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ResourceRequirements resources;
    @Nullable
    @JsonProperty(value="started")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Boolean started;
    @Nullable
    @Valid
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ContainerState state;
    @Nullable
    @Valid
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ContainerUser user;
    @Nullable
    @JsonProperty(value="volumeMounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1VolumeMountStatus> volumeMounts;

    public V1ContainerStatus(String image, String imageID, String name, Boolean ready, Integer restartCount) {
        this.image = image;
        this.imageID = imageID;
        this.name = name;
        this.ready = ready;
        this.restartCount = restartCount;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public V1ContainerStatus image(String image) {
        this.image = image;
        return this;
    }

    public String getImageID() {
        return this.imageID;
    }

    public void setImageID(String imageID) {
        this.imageID = imageID;
    }

    public V1ContainerStatus imageID(String imageID) {
        this.imageID = imageID;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ContainerStatus name(String name) {
        this.name = name;
        return this;
    }

    public Boolean getReady() {
        return this.ready;
    }

    public void setReady(Boolean ready) {
        this.ready = ready;
    }

    public V1ContainerStatus ready(Boolean ready) {
        this.ready = ready;
        return this;
    }

    public Integer getRestartCount() {
        return this.restartCount;
    }

    public void setRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
    }

    public V1ContainerStatus restartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return this;
    }

    public Map<String, @NotNull String> getAllocatedResources() {
        return this.allocatedResources;
    }

    public void setAllocatedResources(Map<String, @NotNull String> allocatedResources) {
        this.allocatedResources = allocatedResources;
    }

    public V1ContainerStatus allocatedResources(Map<String, @NotNull String> allocatedResources) {
        this.allocatedResources = allocatedResources;
        return this;
    }

    public V1ContainerStatus putAllocatedResourcesItem(String key, String allocatedResourcesItem) {
        if (this.allocatedResources == null) {
            this.allocatedResources = new HashMap<String, String>();
        }
        this.allocatedResources.put(key, allocatedResourcesItem);
        return this;
    }

    public List<@Valid V1ResourceStatus> getAllocatedResourcesStatus() {
        return this.allocatedResourcesStatus;
    }

    public void setAllocatedResourcesStatus(List<@Valid V1ResourceStatus> allocatedResourcesStatus) {
        this.allocatedResourcesStatus = allocatedResourcesStatus;
    }

    public V1ContainerStatus allocatedResourcesStatus(List<@Valid V1ResourceStatus> allocatedResourcesStatus) {
        this.allocatedResourcesStatus = allocatedResourcesStatus;
        return this;
    }

    public V1ContainerStatus addAllocatedResourcesStatusItem(V1ResourceStatus allocatedResourcesStatusItem) {
        if (this.allocatedResourcesStatus == null) {
            this.allocatedResourcesStatus = new ArrayList<V1ResourceStatus>();
        }
        this.allocatedResourcesStatus.add(allocatedResourcesStatusItem);
        return this;
    }

    public String getContainerID() {
        return this.containerID;
    }

    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    public V1ContainerStatus containerID(String containerID) {
        this.containerID = containerID;
        return this;
    }

    public V1ContainerState getLastState() {
        return this.lastState;
    }

    public void setLastState(V1ContainerState lastState) {
        this.lastState = lastState;
    }

    public V1ContainerStatus lastState(V1ContainerState lastState) {
        this.lastState = lastState;
        return this;
    }

    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public V1ContainerStatus resources(V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    public Boolean getStarted() {
        return this.started;
    }

    public void setStarted(Boolean started) {
        this.started = started;
    }

    public V1ContainerStatus started(Boolean started) {
        this.started = started;
        return this;
    }

    public V1ContainerState getState() {
        return this.state;
    }

    public void setState(V1ContainerState state) {
        this.state = state;
    }

    public V1ContainerStatus state(V1ContainerState state) {
        this.state = state;
        return this;
    }

    public V1ContainerUser getUser() {
        return this.user;
    }

    public void setUser(V1ContainerUser user) {
        this.user = user;
    }

    public V1ContainerStatus user(V1ContainerUser user) {
        this.user = user;
        return this;
    }

    public List<@Valid V1VolumeMountStatus> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(List<@Valid V1VolumeMountStatus> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    public V1ContainerStatus volumeMounts(List<@Valid V1VolumeMountStatus> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public V1ContainerStatus addVolumeMountsItem(V1VolumeMountStatus volumeMountsItem) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<V1VolumeMountStatus>();
        }
        this.volumeMounts.add(volumeMountsItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerStatus v1ContainerStatus = (V1ContainerStatus)o;
        return Objects.equals(this.image, v1ContainerStatus.image) && Objects.equals(this.imageID, v1ContainerStatus.imageID) && Objects.equals(this.name, v1ContainerStatus.name) && Objects.equals(this.ready, v1ContainerStatus.ready) && Objects.equals(this.restartCount, v1ContainerStatus.restartCount) && Objects.equals(this.allocatedResources, v1ContainerStatus.allocatedResources) && Objects.equals(this.allocatedResourcesStatus, v1ContainerStatus.allocatedResourcesStatus) && Objects.equals(this.containerID, v1ContainerStatus.containerID) && Objects.equals(this.lastState, v1ContainerStatus.lastState) && Objects.equals(this.resources, v1ContainerStatus.resources) && Objects.equals(this.started, v1ContainerStatus.started) && Objects.equals(this.state, v1ContainerStatus.state) && Objects.equals(this.user, v1ContainerStatus.user) && Objects.equals(this.volumeMounts, v1ContainerStatus.volumeMounts);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.imageID, this.name, this.ready, this.restartCount, this.allocatedResources, this.allocatedResourcesStatus, this.containerID, this.lastState, this.resources, this.started, this.state, this.user, this.volumeMounts);
    }

    public String toString() {
        return "V1ContainerStatus(image: " + this.getImage() + ", imageID: " + this.getImageID() + ", name: " + this.getName() + ", ready: " + this.getReady() + ", restartCount: " + this.getRestartCount() + ", allocatedResources: " + String.valueOf(this.getAllocatedResources()) + ", allocatedResourcesStatus: " + String.valueOf(this.getAllocatedResourcesStatus()) + ", containerID: " + this.getContainerID() + ", lastState: " + String.valueOf(this.getLastState()) + ", resources: " + String.valueOf(this.getResources()) + ", started: " + this.getStarted() + ", state: " + String.valueOf(this.getState()) + ", user: " + String.valueOf(this.getUser()) + ", volumeMounts: " + String.valueOf(this.getVolumeMounts()) + ")";
    }
}

