/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"kind", "name", "apiVersion"})
public class V1CrossVersionObjectReference {
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_NAME = "name";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    @NotNull
    @JsonProperty(value="kind")
    private String kind;
    @NotNull
    @JsonProperty(value="name")
    private String name;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;

    public V1CrossVersionObjectReference(String kind, String name) {
        this.kind = kind;
        this.name = name;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1CrossVersionObjectReference kind(String kind) {
        this.kind = kind;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1CrossVersionObjectReference name(String name) {
        this.name = name;
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1CrossVersionObjectReference apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CrossVersionObjectReference v1CrossVersionObjectReference = (V1CrossVersionObjectReference)o;
        return Objects.equals(this.kind, v1CrossVersionObjectReference.kind) && Objects.equals(this.name, v1CrossVersionObjectReference.name) && Objects.equals(this.apiVersion, v1CrossVersionObjectReference.apiVersion);
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.name, this.apiVersion);
    }

    public String toString() {
        return "V1CrossVersionObjectReference(kind: " + this.getKind() + ", name: " + this.getName() + ", apiVersion: " + this.getApiVersion() + ")";
    }
}

