/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.common.KubernetesObject;
import io.micronaut.kubernetes.client.openapi.model.V1CustomResourceDefinitionSpec;
import io.micronaut.kubernetes.client.openapi.model.V1CustomResourceDefinitionStatus;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"spec", "apiVersion", "kind", "metadata", "status"})
public class V1CustomResourceDefinition
implements KubernetesObject {
    public static final String JSON_PROPERTY_SPEC = "spec";
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    public static final String JSON_PROPERTY_STATUS = "status";
    @NotNull
    @Valid
    @JsonProperty(value="spec")
    private V1CustomResourceDefinitionSpec spec;
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;
    @Nullable
    @Valid
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1CustomResourceDefinitionStatus status;

    public V1CustomResourceDefinition(V1CustomResourceDefinitionSpec spec) {
        this.spec = spec;
    }

    public V1CustomResourceDefinitionSpec getSpec() {
        return this.spec;
    }

    public void setSpec(V1CustomResourceDefinitionSpec spec) {
        this.spec = spec;
    }

    public V1CustomResourceDefinition spec(V1CustomResourceDefinitionSpec spec) {
        this.spec = spec;
        return this;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1CustomResourceDefinition apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1CustomResourceDefinition kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1CustomResourceDefinition metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public V1CustomResourceDefinitionStatus getStatus() {
        return this.status;
    }

    public void setStatus(V1CustomResourceDefinitionStatus status) {
        this.status = status;
    }

    public V1CustomResourceDefinition status(V1CustomResourceDefinitionStatus status) {
        this.status = status;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CustomResourceDefinition v1CustomResourceDefinition = (V1CustomResourceDefinition)o;
        return Objects.equals(this.spec, v1CustomResourceDefinition.spec) && Objects.equals(this.apiVersion, v1CustomResourceDefinition.apiVersion) && Objects.equals(this.kind, v1CustomResourceDefinition.kind) && Objects.equals(this.metadata, v1CustomResourceDefinition.metadata) && Objects.equals(this.status, v1CustomResourceDefinition.status);
    }

    public int hashCode() {
        return Objects.hash(this.spec, this.apiVersion, this.kind, this.metadata, this.status);
    }

    public String toString() {
        return "V1CustomResourceDefinition(spec: " + String.valueOf(this.getSpec()) + ", apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", metadata: " + String.valueOf(this.getMetadata()) + ", status: " + String.valueOf(this.getStatus()) + ")";
    }
}

