/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1DaemonSetUpdateStrategy;
import io.micronaut.kubernetes.client.openapi.model.V1LabelSelector;
import io.micronaut.kubernetes.client.openapi.model.V1PodTemplateSpec;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"selector", "template", "minReadySeconds", "revisionHistoryLimit", "updateStrategy"})
public class V1DaemonSetSpec {
    public static final String JSON_PROPERTY_SELECTOR = "selector";
    public static final String JSON_PROPERTY_TEMPLATE = "template";
    public static final String JSON_PROPERTY_MIN_READY_SECONDS = "minReadySeconds";
    public static final String JSON_PROPERTY_REVISION_HISTORY_LIMIT = "revisionHistoryLimit";
    public static final String JSON_PROPERTY_UPDATE_STRATEGY = "updateStrategy";
    @NotNull
    @Valid
    @JsonProperty(value="selector")
    private V1LabelSelector selector;
    @NotNull
    @Valid
    @JsonProperty(value="template")
    private V1PodTemplateSpec template;
    @Nullable
    @JsonProperty(value="minReadySeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer minReadySeconds;
    @Nullable
    @JsonProperty(value="revisionHistoryLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private Integer revisionHistoryLimit;
    @Nullable
    @Valid
    @JsonProperty(value="updateStrategy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1DaemonSetUpdateStrategy updateStrategy;

    public V1DaemonSetSpec(V1LabelSelector selector, V1PodTemplateSpec template) {
        this.selector = selector;
        this.template = template;
    }

    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1DaemonSetSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public V1DaemonSetSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public V1DaemonSetSpec minReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public void setRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
    }

    public V1DaemonSetSpec revisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return this;
    }

    public V1DaemonSetUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(V1DaemonSetUpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public V1DaemonSetSpec updateStrategy(V1DaemonSetUpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1DaemonSetSpec v1DaemonSetSpec = (V1DaemonSetSpec)o;
        return Objects.equals(this.selector, v1DaemonSetSpec.selector) && Objects.equals(this.template, v1DaemonSetSpec.template) && Objects.equals(this.minReadySeconds, v1DaemonSetSpec.minReadySeconds) && Objects.equals(this.revisionHistoryLimit, v1DaemonSetSpec.revisionHistoryLimit) && Objects.equals(this.updateStrategy, v1DaemonSetSpec.updateStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.selector, this.template, this.minReadySeconds, this.revisionHistoryLimit, this.updateStrategy);
    }

    public String toString() {
        return "V1DaemonSetSpec(selector: " + String.valueOf(this.getSelector()) + ", template: " + String.valueOf(this.getTemplate()) + ", minReadySeconds: " + this.getMinReadySeconds() + ", revisionHistoryLimit: " + this.getRevisionHistoryLimit() + ", updateStrategy: " + String.valueOf(this.getUpdateStrategy()) + ")";
    }
}

