/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.model.V1EndpointConditions;
import io.micronaut.kubernetes.client.openapi.model.V1EndpointHints;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectReference;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"addresses", "conditions", "deprecatedTopology", "hints", "hostname", "nodeName", "targetRef", "zone"})
public class V1Endpoint {
    public static final String JSON_PROPERTY_ADDRESSES = "addresses";
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    public static final String JSON_PROPERTY_DEPRECATED_TOPOLOGY = "deprecatedTopology";
    public static final String JSON_PROPERTY_HINTS = "hints";
    public static final String JSON_PROPERTY_HOSTNAME = "hostname";
    public static final String JSON_PROPERTY_NODE_NAME = "nodeName";
    public static final String JSON_PROPERTY_TARGET_REF = "targetRef";
    public static final String JSON_PROPERTY_ZONE = "zone";
    @NotNull
    @JsonProperty(value="addresses")
    private @NotNull List<@NotNull String> addresses;
    @Nullable
    @Valid
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1EndpointConditions conditions;
    @Nullable
    @JsonProperty(value="deprecatedTopology")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable Map<String, @NotNull String> deprecatedTopology;
    @Nullable
    @Valid
    @JsonProperty(value="hints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1EndpointHints hints;
    @Nullable
    @JsonProperty(value="hostname")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String hostname;
    @Nullable
    @JsonProperty(value="nodeName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String nodeName;
    @Nullable
    @Valid
    @JsonProperty(value="targetRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectReference targetRef;
    @Nullable
    @JsonProperty(value="zone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String zone;

    public V1Endpoint(List<@NotNull String> addresses) {
        this.addresses = addresses;
    }

    public List<@NotNull String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<@NotNull String> addresses) {
        this.addresses = addresses;
    }

    public V1Endpoint addresses(List<@NotNull String> addresses) {
        this.addresses = addresses;
        return this;
    }

    public V1Endpoint addAddressesItem(String addressesItem) {
        this.addresses.add(addressesItem);
        return this;
    }

    public V1EndpointConditions getConditions() {
        return this.conditions;
    }

    public void setConditions(V1EndpointConditions conditions) {
        this.conditions = conditions;
    }

    public V1Endpoint conditions(V1EndpointConditions conditions) {
        this.conditions = conditions;
        return this;
    }

    public Map<String, @NotNull String> getDeprecatedTopology() {
        return this.deprecatedTopology;
    }

    public void setDeprecatedTopology(Map<String, @NotNull String> deprecatedTopology) {
        this.deprecatedTopology = deprecatedTopology;
    }

    public V1Endpoint deprecatedTopology(Map<String, @NotNull String> deprecatedTopology) {
        this.deprecatedTopology = deprecatedTopology;
        return this;
    }

    public V1Endpoint putDeprecatedTopologyItem(String key, String deprecatedTopologyItem) {
        if (this.deprecatedTopology == null) {
            this.deprecatedTopology = new HashMap<String, String>();
        }
        this.deprecatedTopology.put(key, deprecatedTopologyItem);
        return this;
    }

    public V1EndpointHints getHints() {
        return this.hints;
    }

    public void setHints(V1EndpointHints hints) {
        this.hints = hints;
    }

    public V1Endpoint hints(V1EndpointHints hints) {
        this.hints = hints;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public V1Endpoint hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public V1Endpoint nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public V1ObjectReference getTargetRef() {
        return this.targetRef;
    }

    public void setTargetRef(V1ObjectReference targetRef) {
        this.targetRef = targetRef;
    }

    public V1Endpoint targetRef(V1ObjectReference targetRef) {
        this.targetRef = targetRef;
        return this;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public V1Endpoint zone(String zone) {
        this.zone = zone;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Endpoint v1Endpoint = (V1Endpoint)o;
        return Objects.equals(this.addresses, v1Endpoint.addresses) && Objects.equals(this.conditions, v1Endpoint.conditions) && Objects.equals(this.deprecatedTopology, v1Endpoint.deprecatedTopology) && Objects.equals(this.hints, v1Endpoint.hints) && Objects.equals(this.hostname, v1Endpoint.hostname) && Objects.equals(this.nodeName, v1Endpoint.nodeName) && Objects.equals(this.targetRef, v1Endpoint.targetRef) && Objects.equals(this.zone, v1Endpoint.zone);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.conditions, this.deprecatedTopology, this.hints, this.hostname, this.nodeName, this.targetRef, this.zone);
    }

    public String toString() {
        return "V1Endpoint(addresses: " + String.valueOf(this.getAddresses()) + ", conditions: " + String.valueOf(this.getConditions()) + ", deprecatedTopology: " + String.valueOf(this.getDeprecatedTopology()) + ", hints: " + String.valueOf(this.getHints()) + ", hostname: " + this.getHostname() + ", nodeName: " + this.getNodeName() + ", targetRef: " + String.valueOf(this.getTargetRef()) + ", zone: " + this.getZone() + ")";
    }
}

