/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.openapi.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.openapi.common.KubernetesObject;
import io.micronaut.kubernetes.client.openapi.model.V1EndpointSubset;
import io.micronaut.kubernetes.client.openapi.model.V1ObjectMeta;
import io.micronaut.serde.annotation.Serdeable;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Serdeable
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "subsets"})
public class V1Endpoints
implements KubernetesObject {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    public static final String JSON_PROPERTY_KIND = "kind";
    public static final String JSON_PROPERTY_METADATA = "metadata";
    public static final String JSON_PROPERTY_SUBSETS = "subsets";
    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String apiVersion;
    @Nullable
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private String kind;
    @Nullable
    @Valid
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private V1ObjectMeta metadata;
    @Nullable
    @JsonProperty(value="subsets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    private @Nullable List<@Valid V1EndpointSubset> subsets;

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1Endpoints apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1Endpoints kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1Endpoints metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<@Valid V1EndpointSubset> getSubsets() {
        return this.subsets;
    }

    public void setSubsets(List<@Valid V1EndpointSubset> subsets) {
        this.subsets = subsets;
    }

    public V1Endpoints subsets(List<@Valid V1EndpointSubset> subsets) {
        this.subsets = subsets;
        return this;
    }

    public V1Endpoints addSubsetsItem(V1EndpointSubset subsetsItem) {
        if (this.subsets == null) {
            this.subsets = new ArrayList<V1EndpointSubset>();
        }
        this.subsets.add(subsetsItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Endpoints v1Endpoints = (V1Endpoints)o;
        return Objects.equals(this.apiVersion, v1Endpoints.apiVersion) && Objects.equals(this.kind, v1Endpoints.kind) && Objects.equals(this.metadata, v1Endpoints.metadata) && Objects.equals(this.subsets, v1Endpoints.subsets);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.subsets);
    }

    public String toString() {
        return "V1Endpoints(apiVersion: " + this.getApiVersion() + ", kind: " + this.getKind() + ", metadata: " + String.valueOf(this.getMetadata()) + ", subsets: " + String.valueOf(this.getSubsets()) + ")";
    }
}

